# ClusterLabs Policy for AI-Generated Code

## Introduction and Purpose
This policy outlines the guidelines and requirements for the use of Artificial Intelligence (AI) generated code within the pcs project. As AI code generation tools become increasingly prevalent, it is crucial to establish clear standards to ensure transparency, maintain code quality, uphold licensing integrity, and address potential ethical and security concerns.

This policy aims to facilitate responsible and effective integration of AI tools while safeguarding the principles of open-source collaboration.

## What is AI-Generated Code
Any code, code snippets, configurations, documentation, or other programmatic assets produced, suggested, or significantly modified by an artificial intelligence model, tool, or service (e.g., GitHub Copilot, ChatGPT, Gemini, etc.).

This includes code that is directly used, or heavily adapted from AI suggestions.

## The policy
At the time of writing, pcs project does NOT accept any AI-Generated Code.

## Rationale
The AI world is moving extremely fast. There are several concerns related to intellectual property, quality, and ethics.

The pcs maintainers are in the process of evaluating safe use cases where AI-Generated Code might be admissible.

## Enforcement and Dispute Resolution
Non-Compliance: Failure to adhere to this policy may result in the rejection of Pull Requests.

Disputes: Any disputes or concerns regarding the use of AI-generated code will be discussed and resolved by the pcs maintainers.

## Disclaimer
This policy is a living document and will be updated as AI technology evolves and best practices emerge. Contributors are encouraged to provide feedback and suggestions to improve this policy over time.

The current policy is maintained here: https://github.com/ClusterLabs/ai-policies

Last update: 2025-08-14
