# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class SelectionNode(Object):
    r"""
    SelectionNode - a node in a Selection the defines the selection
    criteria.
    
    Superclass: Object
    
    SelectionNode helps define the selection criteria in a
    Selection. Selection can comprise of multiple such
    SelectionNode instances that help define the selection.
    
    SelectionNode has two components: a list of properties (stored in
    a Information) and a selection list (a AbstractArray subclass).
    The properties help indicate how to interpret the values specified in
    a selection-list.
    
    The properties can be broadly classified into three categories: core,
    qualifiers, and information. The core properties must be specified
    other wise the SelectionNode is not considered valid. These are
    `FIELD_TYPE` and `CONTENT_TYPE`. `FIELD_TYPE` defines what kinds of
    entities are being selected. Since selections are used select items
    in a data-object, these correspond to things like cells, points,
    nodes, edges, rows, etc. Supported FIELD_TYPE values are defined in
    `vtkselection_node::selection_field`. `CONTENT_TYPE` defines the how
    the selection is described. Supported values are
    `vtkselection_node::selection_content`. For example, if CONTENT_TYPE is
    `INDICES`, then selection is described as ids for entities being
    selected. The ids themselves will be specified using the selection
    list. Thus, the CONTENT_TYPE dictates what the selection list
    comprises.
    
    Qualifiers are used to further qualify the selection criteria. All
    qualifiers are optional. When present they restrict the selection.
    For example, when selecting elements from a composite-dataset, the
    `COMPOSITE_INDEX` qualifier can be specified of limit the selection
    to a specific dataset (or subtree).
    
    Information properties are simply for informative purposes and
    generally used to provide information about the selection when the
    selection is created. For example, `PIXEL_COUNT` is used to indicate
    how many screen pixels resulted in creation of this selection node.
    
    @section selection_types Selection Types
    
    `CONTENT_TYPE` property is one of the required properties that helps
    describe how the selection is defined. To set the content type, one
    can access the properties store using
    `vtkselection_node::get_properties()` and then set the `CONTENT_TYPE`
    using the `vtkselection_node::CONTENT_TYPE()` key or simply use
    `vtkselection_node::set_content_type`.
    
    * `vtkselection_node::GLOBALIDS`: indicates that the selection is
      defined using global ids. In VTK data-object, global ids are
      specified an `vtkid_type_array` added to a appropriate
      `vtkdata_set_attributes` and marked as global-ids using
      DataSetAttributes API. Since global ids are expected to be
      unique for that element type over the entire dataset, it's a
      convenient way of defining selections. For this content-type, the
      selection list must be to a single-component, `vtkid_type_array` that
    lists all the globals ids for the selected elements.
    
    * `vtkselection_node::PEDIGREEIDS`: similar to `GLOBALIDS` except uses
      pedigree ids instead of global ids.
    
    * `vtkselection_node::VALUES`: this type is used to define a selection
    based on array values. The selection list specifies the values to be
      selected. All elements with array values in the selection list are
      treated as selected. The qualifier COMPONENT_NUMBER is used to
      indicate which component to use for the checks. Use `-1` for
      magnitude. Current implementation does not support checking
      multiple-components or non-exact matches although support for both
      is conceivable in future. The selection list array name is used to
      specify the name of the array from the dataset to use for the
      checks. Thus, for defining a selection for a dataset where all
      `TEMP` values match those specified in the selection list, ensure
      that the selection list array's name is set to `TEMP` as well.
    
    * `vtkselection_node::INDICES`: this is similar to global ids except
      in this case the selection list is simply the VTK element id which
      is 0-based index of that element in the particular dataset. Often
      with this type of selection, additional qualifiers such as
      `COMPOSITE_INDEX`, `BLOCK_SELECTORS`, `PROCESS_ID` etc. are needed
      to correctly identify the chosen element(s) in case of composite or
    distributed datasets.
    
    * `vtkselection_node::FRUSTUM: this type is used to define a frustum
      in world coordinates that identifies the selected elements. In this
    case, the selection list is a DoubleArray with 32 values
      specifying the 8 frustum corners in homogeneous world coordinates.
    
    * `vtkselection_node::LOCATIONS`: this is used to select points (or
      cells) near (or containing) specified locations. The selection list
    is a 3-compnent DoubleArray with coordinates for locations of
      interest.
    
    * `vtkselection_node::THRESHOLDS`: this type is used to define a
      selection based on array value ranges. This is akin to
      thresholding. All elements with values in the specified ranges are
      to be treated as selected. For this content-type, the
      selection-list is a 2-component `vtkdata_array`-subclass that
      specifies where each tuple defines the min and max values for a
      range. The selection list can have multiple tuples to define
      multiple ranges. Elements with values in any of the specified
      ranges are treated as selected. The selection list array name is
      used to specify the name of the array from the dataset to use for
      the checks. Thus, for defining a selection for a dataset where all
      `TEMP` values are within a range, ensure that the selection list
      array's name is set to `TEMP` as well.
    
    * `vtkselection_node::BLOCKS`: this type is used to select blocks in a
      composite dataset. The term blocks is used loosely here and can
      correspond to a block in a multiblock dataset or a partition in a
      partitioned-dataset. The selection list is an integral type
      DataArray subclass that can be 1- or 2- component. If
      1-component, it's interpreted as the composite-index (also called
      flat index) and can be applied to any composite-dataset to choose
      specific datasets. If 2-component, it's typically associated with
      UniformGridAMR or PartitionedDataSetCollection which support
      2-tuple indexing to locate a dataset.
    
    * `vtkselection_node::BLOCK_SELECTORS`: this is similar to BLOCKS,
      however instead of using indices to select datasets, here, the
      selection list is a StringArray which lists selector expressions
    to select blocks in the composite dataset. By default, the selector
      expressions are applied to a DataAssembly generated from the
      composite dataset that represents its hierarchy (see
      `vtkdata_assembly::generate_hierarchy`). However, in case of
      PartitionedDataSetCollection, one can select any other data
      assembly associated with the PartitionedDataSetCollection by
      naming the array with the name of the assembly.
    
    ote, currently PartitionedDataSetCollection only supports a single
      DataAssembly but this may change in the future.
    
    * `vtkselection_node::QUERY`: this type is primarily added for
      para_view where selection expression is specified as a query string.
    This is likely to change in the future and hence applications are
      discouraged from using this type.
    
    @section Properties Properties
    
    Following a properties that can be used to qualify the selection.
    
    * `vtkselection_node::EPSILON()`: this is a qualifier that can be used
    to indicate a fuzz-factor when comparing values for equality.
      Currently, this is only used with content-type LOCATIONS, however,
      it can be expanded to other selection types in the future.
    
    * `vtkselection_node::CONTAINING_CELLS()`: this qualifier is intended
      to be used with field-type `POINT`. When present, it indicates that
    while the selection criteria selects a collection of points the
      selection should be formed using cell containing the chosen points.
    
    * `vtkselection_node::CONNECTED_LAYERS()`: a qualifier used to expand
      the definition of selected elements to connected elements for the
      specified number of layers. Layers can be positive or negative to
      grow or shrink the selection respectively.
    
    * `vtkselection_node::INVERSE()`: a qualifier that causes the
      selection to be inverted i.e. all elements not chosen by the
      criteria are to be treated as selected.
    
    * `vtkselection_node::COMPONENT_NUMBER()`: for VALUES and THRESHOLDS
      selection types, this qualifier identifies the array component of
      interest. -1 indicates magnitude.
    
    * `vtkselection_node::PROCESS_ID()`: limits the selection to a
      particular rank in a distributed environment.
    
    * `vtkselection_node::COMPOSITE_INDEX()`: a qualifier used to limit
      the selection to a specific composite index for a
      composite-dataset.
    
    * `vtkselection_node::ASSEMBLY_NAME()`,
      `vtkselection_node::SELECTORS()`: similar to composite index, except
    uses data-assembly and selectors to limit the selection to a subset
      of nodes in a composite-dataset.
    
    * `vtkselection_node::HIERARCHICAL_LEVEL()`,
      `vtkselection_node::HIERARCHICAL_INDEX()`: similar to composite
      index, except uses level and index for an AMR dataset so limit the
      selection to a specific AMR level or dataset.
    
    Following for properties that are primarily intended to provide
    additional information when the selection is created.
    
    * `vtkselection_node::ZBUFFER_VALUE()`: an information qualifier
      representing the z-depth for a particular selection when it was
      created.
    
    * `vtkselection_node::PIXEL_COUNT()`: a qualifier used to provide a
      count for the number of pixels that resulted in this selection.
    
    * `vtkselection_node::SOURCE()`, `vtkselection_node::SOURCE_ID()`:
      provides information about data producer or selection originator.
      The interpretation is very specific to the creator creating the
      selection and varies greatly with VTK.
    
    * `vtkselection_node::PROP(), `vtkselection_node::PROP_ID()`: similar
      to SOURCE/SOURCE_ID except is used to represent a rendering prop
      from which the selection was created.
    
    @warning
    No selection_list is created by default. It should be assigned.
    
    @section selection_field_mismatch SelectionNode::SelectionField and
    DataSetAttribute::AttributeTypes
    
    Strictly speaking, SelectionNode::SelectionField maps directly to
    DataSetAttribute::AttributeTypes. However, the two enum values are
    not identical for historical reasons. Use
    `vtkselection_node::convert_selection_field_to_attribute_type` and
    `vtkselection_node::convert_attribute_type_to_selection_field` to convert
    between the two.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSelectionNode, obj, update, **traits)
    
    content_type = traits.Int(-1, enter_set=True, auto_set=False, desc=\
        r"""
        Get or set the content type of the selection. This is the same as
        setting the CONTENT_TYPE() key on the property.
        """
    )

    def _content_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetContentType,
                        self.content_type)

    field_type = traits.Int(-1, enter_set=True, auto_set=False, desc=\
        r"""
        Get or set the field type of the selection. This is the same as
        setting the FIELD_TYPE() key on the property.
        """
    )

    def _field_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFieldType,
                        self.field_type)

    query_string = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the query expression string.
        """
    )

    def _query_string_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetQueryString,
                        self.query_string)

    def _get_selection_data(self):
        return wrap_vtk(self._vtk_obj.GetSelectionData())
    def _set_selection_data(self, arg):
        old_val = self._get_selection_data()
        self._wrap_call(self._vtk_obj.SetSelectionData,
                        deref_vtk(arg))
        self.trait_property_changed('selection_data', old_val, arg)
    selection_data = traits.Property(_get_selection_data, _set_selection_data, desc=\
        r"""
        
        """
    )

    def _get_selection_list(self):
        return wrap_vtk(self._vtk_obj.GetSelectionList())
    def _set_selection_list(self, arg):
        old_val = self._get_selection_list()
        my_arg = deref_array([arg], [['vtkAbstractArray']])
        self._wrap_call(self._vtk_obj.SetSelectionList,
                        my_arg[0])
        self.trait_property_changed('selection_list', old_val, arg)
    selection_list = traits.Property(_get_selection_list, _set_selection_list, desc=\
        r"""
        
        """
    )

    def get_content_type_as_string(self, *args):
        """
        get_content_type_as_string(type:int) -> str
        C++: static const char *get_content_type_as_string(int type)
        Get the content type as a string.
        """
        ret = self._wrap_call(self._vtk_obj.GetContentTypeAsString, *args)
        return ret

    def get_field_type_as_string(self, *args):
        """
        get_field_type_as_string(type:int) -> str
        C++: static const char *get_field_type_as_string(int type)
        Get the field type as a string.
        """
        ret = self._wrap_call(self._vtk_obj.GetFieldTypeAsString, *args)
        return ret

    def get_field_type_from_string(self, *args):
        """
        get_field_type_from_string(type:str) -> int
        C++: static int get_field_type_from_string(const char *type)
        Get field type from string. Returns NUM_FIELD_TYPES if not found.
        """
        ret = self._wrap_call(self._vtk_obj.GetFieldTypeFromString, *args)
        return ret

    def _get_properties(self):
        return wrap_vtk(self._vtk_obj.GetProperties())
    properties = traits.Property(_get_properties, desc=\
        r"""
        Returns the property map.
        """
    )

    def ASSEMBLY_NAME(self):
        """
        assembly__name() -> InformationStringKey
        C++: static InformationStringKey *assembly__name()
        Keys for selector-based identification of blocks to choose from a
        composite dataset. `ASSEMBLY_NAME` identifies the name for the
        assembly to use and `SELECTORS` provide a list of node selectors
        applied to the chosen assembly.
        
        Use `vtkdata_assembly_utilities::hierarchy_name` as the assembly
        name to use the data hierarchy
        """
        ret = wrap_vtk(self._vtk_obj.ASSEMBLY_NAME())
        return ret
        

    def COMPONENT_NUMBER(self):
        """
        component__number() -> InformationIntegerKey
        C++: static InformationIntegerKey *component__number()
        When content_type==THRESHOLDS  or content_type==VALUES i.e.
        threshold and value based selections, it is possible pick the
        component number using this key. If none is specified, the 0th
        component is used. If any number less than 0 is specified, then
        the magnitude is used.
        """
        ret = wrap_vtk(self._vtk_obj.COMPONENT_NUMBER())
        return ret
        

    def COMPOSITE_INDEX(self):
        """
        composite__index() -> InformationIntegerKey
        C++: static InformationIntegerKey *composite__index()
        Used to identify a node in composite datasets.
        """
        ret = wrap_vtk(self._vtk_obj.COMPOSITE_INDEX())
        return ret
        

    def CONNECTED_LAYERS(self):
        """
        connected__layers() -> InformationIntegerKey
        C++: static InformationIntegerKey *connected__layers()
        When specified, this indicates how many layers of *connected*
        elements in addition to those chosen explicitly are being
        selected. Currently, this is only supported for cells and points.
        """
        ret = wrap_vtk(self._vtk_obj.CONNECTED_LAYERS())
        return ret
        

    def CONTAINING_CELLS(self):
        """
        containing__cells() -> InformationIntegerKey
        C++: static InformationIntegerKey *containing__cells()
        This flag tells the extraction filter, when FIELD_TYPE==POINT,
        that it should also extract the cells that contain any of the
        extracted points.
        """
        ret = wrap_vtk(self._vtk_obj.CONTAINING_CELLS())
        return ret
        

    def CONTENT_TYPE(self):
        """
        content__type() -> InformationIntegerKey
        C++: static InformationIntegerKey *content__type()
        Get the (primary) property that describes the content of a
        selection node's data. This key takes on values from the
        selection_content enum. get_content_type() returns -1 if the content
        type is not set.
        
        \\sa SelectionNode::SelectionContent
        """
        ret = wrap_vtk(self._vtk_obj.CONTENT_TYPE())
        return ret
        

    def convert_attribute_type_to_selection_field(self, *args):
        """
        convert_attribute_type_to_selection_field(val:int) -> int
        C++: static int convert_attribute_type_to_selection_field(int val)"""
        ret = self._wrap_call(self._vtk_obj.ConvertAttributeTypeToSelectionField, *args)
        return ret

    def convert_selection_field_to_attribute_type(self, *args):
        """
        convert_selection_field_to_attribute_type(val:int) -> int
        C++: static int convert_selection_field_to_attribute_type(int val)
        Methods to convert SelectionNode::SelectionField to
        DataSetAttribute::AttributeTypes and vice-versa.
        """
        ret = self._wrap_call(self._vtk_obj.ConvertSelectionFieldToAttributeType, *args)
        return ret

    def deep_copy(self, *args):
        """
        deep_copy(self, src:SelectionNode) -> None
        C++: virtual void deep_copy(SelectionNode *src)
        Copy properties, selection list and children of the input.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DeepCopy, *my_args)
        return ret

    def EPSILON(self):
        """
        epsilon() -> InformationDoubleKey
        C++: static InformationDoubleKey *epsilon()
        For location selection of points, if distance is greater than
        this reject.
        """
        ret = wrap_vtk(self._vtk_obj.EPSILON())
        return ret
        

    def equal_properties(self, *args):
        """
        equal_properties(self, other:SelectionNode,
            fullcompare:bool=True) -> bool
        C++: bool equal_properties(SelectionNode *other,
            bool fullcompare=true)
        Compares Properties of self and other to ensure that they are
        exactly same.
        """
        ret = self._wrap_call(self._vtk_obj.EqualProperties, *args)
        return ret

    def FIELD_TYPE(self):
        """
        field__type() -> InformationIntegerKey
        C++: static InformationIntegerKey *field__type()
        Controls whether cell, point, or field data determine what is
        inside and out. The default is CELL. Vertex and edge types are
        also available for graph classes. get_field_type() returns -1 if
        the field type is not set.
        """
        ret = wrap_vtk(self._vtk_obj.FIELD_TYPE())
        return ret
        

    def HIERARCHICAL_INDEX(self):
        """
        hierarchical__index() -> InformationIntegerKey
        C++: static InformationIntegerKey *hierarchical__index()"""
        ret = wrap_vtk(self._vtk_obj.HIERARCHICAL_INDEX())
        return ret
        

    def HIERARCHICAL_LEVEL(self):
        """
        hierarchical__level() -> InformationIntegerKey
        C++: static InformationIntegerKey *hierarchical__level()
        Used to identify a dataset in a hiererchical box dataset.
        """
        ret = wrap_vtk(self._vtk_obj.HIERARCHICAL_LEVEL())
        return ret
        

    def INDEXED_VERTICES(self):
        """
        indexed__vertices() -> InformationIntegerKey
        C++: static InformationIntegerKey *indexed__vertices()
        @deprecated no longer relevant.
        """
        ret = wrap_vtk(self._vtk_obj.INDEXED_VERTICES())
        return ret
        

    def INVERSE(self):
        """
        inverse() -> InformationIntegerKey
        C++: static InformationIntegerKey *inverse()
        This flag tells the extraction filter to exclude the selection.
        """
        ret = wrap_vtk(self._vtk_obj.INVERSE())
        return ret
        

    def initialize(self):
        """
        initialize(self) -> None
        C++: virtual void initialize()
        Restore data object to initial state,
        """
        ret = self._vtk_obj.Initialize()
        return ret
        

    def PIXEL_COUNT(self):
        """
        pixel__count() -> InformationIntegerKey
        C++: static InformationIntegerKey *pixel__count()
        A helper for visible cell selector, this is the number of pixels
        covered by the actor whose cells are listed in the selection.
        """
        ret = wrap_vtk(self._vtk_obj.PIXEL_COUNT())
        return ret
        

    def PROCESS_ID(self):
        """
        process__id() -> InformationIntegerKey
        C++: static InformationIntegerKey *process__id()
        Process id the selection is on.
        """
        ret = wrap_vtk(self._vtk_obj.PROCESS_ID())
        return ret
        

    def PROP(self):
        """
        prop() -> InformationObjectBaseKey
        C++: static InformationObjectBaseKey *prop()
        Pointer to the prop the selection belongs to.
        """
        ret = wrap_vtk(self._vtk_obj.PROP())
        return ret
        

    def PROP_ID(self):
        """
        prop__id() -> InformationIntegerKey
        C++: static InformationIntegerKey *prop__id()
        ID of the prop the selection belongs to. What ID means is
        application specific.
        """
        ret = wrap_vtk(self._vtk_obj.PROP_ID())
        return ret
        

    def SELECTORS(self):
        """
        selectors() -> InformationStringVectorKey
        C++: static InformationStringVectorKey *selectors()"""
        ret = wrap_vtk(self._vtk_obj.SELECTORS())
        return ret
        

    def SOURCE(self):
        """
        source() -> InformationObjectBaseKey
        C++: static InformationObjectBaseKey *source()
        Pointer to the data or algorithm the selection belongs to.
        """
        ret = wrap_vtk(self._vtk_obj.SOURCE())
        return ret
        

    def SOURCE_ID(self):
        """
        source__id() -> InformationIntegerKey
        C++: static InformationIntegerKey *source__id()
        ID of the data or algorithm the selection belongs to. What ID
        means is application specific.
        """
        ret = wrap_vtk(self._vtk_obj.SOURCE_ID())
        return ret
        

    def shallow_copy(self, *args):
        """
        shallow_copy(self, src:SelectionNode) -> None
        C++: virtual void shallow_copy(SelectionNode *src)
        Copy properties, selection list and children of the input. This
        is a shallow copy: selection lists and pointers in the properties
        are passed by reference.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ShallowCopy, *my_args)
        return ret

    def subtract_selection_list(self, *args):
        """
        subtract_selection_list(self, other:SelectionNode) -> None
        C++: void subtract_selection_list(SelectionNode *other)
        Subtracts the items in the selection list, other, from this
        selection list. Assumes that both selections have identical
        properties (i.e., test with equal_properties before using).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SubtractSelectionList, *my_args)
        return ret

    def union_selection_list(self, *args):
        """
        union_selection_list(self, other:SelectionNode) -> None
        C++: void union_selection_list(SelectionNode *other)
        Merges the selection list between self and the other. Assumes
        that both has identical properties.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.UnionSelectionList, *my_args)
        return ret

    def ZBUFFER_VALUE(self):
        """
        zbuffer__value() -> InformationDoubleKey
        C++: static InformationDoubleKey *zbuffer__value()
        If present, closest zbuffer value of this selection
        """
        ret = wrap_vtk(self._vtk_obj.ZBUFFER_VALUE())
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('content_type', 'GetContentType'),
    ('field_type', 'GetFieldType'), ('query_string', 'GetQueryString'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'content_type', 'field_type',
    'query_string'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SelectionNode, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SelectionNode properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['content_type', 'field_type', 'query_string']),
            title='Edit SelectionNode properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SelectionNode properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

