
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file XmlSceneNodeAttributes.h
    \\brief Definition of XmlSceneNode Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "XmlSceneNodeAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

XmlSceneNodeAttributes::XmlSceneNodeAttributes():
	bottom_(ParameterManager::getString("scene_node_bottom")),
	left_(ParameterManager::getString("scene_node_left")),
	width_(ParameterManager::getString("scene_node_width")),
	height_(ParameterManager::getString("scene_node_height")),
	margin_bottom_(ParameterManager::getString("scene_node_margin_bottom")),
	margin_left_(ParameterManager::getString("scene_node_margin_left")),
	margin_right_(ParameterManager::getString("scene_node_margin_right")),
	margin_top_(ParameterManager::getString("scene_node_margin_top")),
	border_bottom_(ParameterManager::getString("scene_node_border_bottom")),
	border_left_(ParameterManager::getString("scene_node_border_left")),
	border_right_(ParameterManager::getString("scene_node_border_right")),
	border_(ParameterManager::getBool("scene_node_border")),
	border_top_(ParameterManager::getString("scene_node_border_top")),
	border_thickness_(ParameterManager::getInt("scene_node_border_thickness")),
	padding_bottom_(ParameterManager::getString("scene_node_padding_bottom")),
	padding_left_(ParameterManager::getString("scene_node_padding_left")),
	padding_right_(ParameterManager::getString("scene_node_padding_right")),
	padding_top_(ParameterManager::getString("scene_node_padding_top"))
	,
	display_(MagTranslator<string, DisplayType>().magics("view_display")),
	background_(MagTranslator<string, Colour>().magics("scene_node_background_colour")),
	border_colour_(MagTranslator<string, Colour>().magics("scene_node_border_colour")),
	border_style_(MagTranslator<string, LineStyle>().magics("scene_node_border_style")),
	padding_colour_(MagTranslator<string, Colour>().magics("scene_node_padding_colour")),
	page_id_(MagTranslator<string, NoPageID>().magics("scene_node_id_line"))
	 
{
} 


XmlSceneNodeAttributes::~XmlSceneNodeAttributes()
{
	
}

    
void XmlSceneNodeAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	int i = 0;
	prefix[i++] = "scene_node";
	prefix[i++] = "view";
	
	setAttribute(prefix, "scene_node_bottom", bottom_, params);
	setAttribute(prefix, "scene_node_left", left_, params);
	setAttribute(prefix, "scene_node_width", width_, params);
	setAttribute(prefix, "scene_node_height", height_, params);
	setAttribute(prefix, "scene_node_margin_bottom", margin_bottom_, params);
	setAttribute(prefix, "scene_node_margin_left", margin_left_, params);
	setAttribute(prefix, "scene_node_margin_right", margin_right_, params);
	setAttribute(prefix, "scene_node_margin_top", margin_top_, params);
	setAttribute(prefix, "scene_node_border_bottom", border_bottom_, params);
	setAttribute(prefix, "scene_node_border_left", border_left_, params);
	setAttribute(prefix, "scene_node_border_right", border_right_, params);
	setAttribute(prefix, "scene_node_border", border_, params);
	setAttribute(prefix, "scene_node_border_top", border_top_, params);
	setAttribute(prefix, "scene_node_border_thickness", border_thickness_, params);
	setAttribute(prefix, "scene_node_padding_bottom", padding_bottom_, params);
	setAttribute(prefix, "scene_node_padding_left", padding_left_, params);
	setAttribute(prefix, "scene_node_padding_right", padding_right_, params);
	setAttribute(prefix, "scene_node_padding_top", padding_top_, params);
	
	setAttribute(prefix, "view_display", display_, params);
	setMember(prefix, "scene_node_background_colour", background_, params);
	setMember(prefix, "scene_node_border_colour", border_colour_, params);
	setAttribute(prefix, "scene_node_border_style", border_style_, params);
	setMember(prefix, "scene_node_padding_colour", padding_colour_, params);
	setMember(prefix, "scene_node_id_line", page_id_, params);
	
}

void XmlSceneNodeAttributes::copy(const XmlSceneNodeAttributes& other)
{
	bottom_ = other.bottom_;
	left_ = other.left_;
	width_ = other.width_;
	height_ = other.height_;
	margin_bottom_ = other.margin_bottom_;
	margin_left_ = other.margin_left_;
	margin_right_ = other.margin_right_;
	margin_top_ = other.margin_top_;
	border_bottom_ = other.border_bottom_;
	border_left_ = other.border_left_;
	border_right_ = other.border_right_;
	border_ = other.border_;
	border_top_ = other.border_top_;
	border_thickness_ = other.border_thickness_;
	padding_bottom_ = other.padding_bottom_;
	padding_left_ = other.padding_left_;
	padding_right_ = other.padding_right_;
	padding_top_ = other.padding_top_;
	display_ = other.display_;
	background_ = unique_ptr<Colour>(other.background_->clone());
	border_colour_ = unique_ptr<Colour>(other.border_colour_->clone());
	border_style_ = other.border_style_;
	padding_colour_ = unique_ptr<Colour>(other.padding_colour_->clone());
	page_id_ = unique_ptr<NoPageID>(other.page_id_->clone());
	
} 


bool XmlSceneNodeAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "page")  )
		return true;
	if ( acceptNode(node, page_id_) )
		return true;
	
	return false;
}

void XmlSceneNodeAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "page")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		setMember(node.name(), page_id_, node);
		
	}
	for (auto &elt : node.elements())
	{
		setMember(elt->name(), page_id_, *elt); 
		
	}
}

void XmlSceneNodeAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " bottom = " <<  bottom_;
	out << " left = " <<  left_;
	out << " width = " <<  width_;
	out << " height = " <<  height_;
	out << " margin_bottom = " <<  margin_bottom_;
	out << " margin_left = " <<  margin_left_;
	out << " margin_right = " <<  margin_right_;
	out << " margin_top = " <<  margin_top_;
	out << " border_bottom = " <<  border_bottom_;
	out << " border_left = " <<  border_left_;
	out << " border_right = " <<  border_right_;
	out << " border = " <<  border_;
	out << " border_top = " <<  border_top_;
	out << " border_thickness = " <<  border_thickness_;
	out << " padding_bottom = " <<  padding_bottom_;
	out << " padding_left = " <<  padding_left_;
	out << " padding_right = " <<  padding_right_;
	out << " padding_top = " <<  padding_top_;
	out << " display = " <<  display_;
	out << " background = " <<  *background_;
	out << " border_colour = " <<  *border_colour_;
	out << " border_style = " <<  border_style_;
	out << " padding_colour = " <<  *padding_colour_;
	out << " page_id = " <<  *page_id_;
	
	out << "]" << "\n";
}

void XmlSceneNodeAttributes::toxml(ostream& out)  const
{
	out <<  "\"page\""; 
	out << ", \"scene_node_bottom\":";
	niceprint(out,bottom_);
	out << ", \"scene_node_left\":";
	niceprint(out,left_);
	out << ", \"scene_node_width\":";
	niceprint(out,width_);
	out << ", \"scene_node_height\":";
	niceprint(out,height_);
	out << ", \"scene_node_margin_bottom\":";
	niceprint(out,margin_bottom_);
	out << ", \"scene_node_margin_left\":";
	niceprint(out,margin_left_);
	out << ", \"scene_node_margin_right\":";
	niceprint(out,margin_right_);
	out << ", \"scene_node_margin_top\":";
	niceprint(out,margin_top_);
	out << ", \"scene_node_border_bottom\":";
	niceprint(out,border_bottom_);
	out << ", \"scene_node_border_left\":";
	niceprint(out,border_left_);
	out << ", \"scene_node_border_right\":";
	niceprint(out,border_right_);
	out << ", \"scene_node_border\":";
	niceprint(out,border_);
	out << ", \"scene_node_border_top\":";
	niceprint(out,border_top_);
	out << ", \"scene_node_border_thickness\":";
	niceprint(out,border_thickness_);
	out << ", \"scene_node_padding_bottom\":";
	niceprint(out,padding_bottom_);
	out << ", \"scene_node_padding_left\":";
	niceprint(out,padding_left_);
	out << ", \"scene_node_padding_right\":";
	niceprint(out,padding_right_);
	out << ", \"scene_node_padding_top\":";
	niceprint(out,padding_top_);
	out << ", \"view_display\":";
	niceprint(out, display_);
	out << ", \"scene_node_background_colour\":";
	niceprint(out, *background_);
	out << ", \"scene_node_border_colour\":";
	niceprint(out, *border_colour_);
	out << ", \"scene_node_border_style\":";
	niceprint(out, border_style_);
	out << ", \"scene_node_padding_colour\":";
	niceprint(out, *padding_colour_);
	out << ", \"scene_node_id_line\":";
	page_id_->toxml(out);
	
}

static MagicsParameter<string> scene_node_bottom("scene_node_bottom", "0%", "");
static MagicsParameter<string> scene_node_left("scene_node_left", "0%", "");
static MagicsParameter<string> scene_node_width("scene_node_width", "100%", "");
static MagicsParameter<string> scene_node_height("scene_node_height", "100%", "");
static MagicsParameter<string> scene_node_margin_bottom("scene_node_margin_bottom", "0%", "");
static MagicsParameter<string> scene_node_margin_left("scene_node_margin_left", "0%", "");
static MagicsParameter<string> scene_node_margin_right("scene_node_margin_right", "0%", "");
static MagicsParameter<string> scene_node_margin_top("scene_node_margin_top", "0%", "");
static MagicsParameter<string> scene_node_border_bottom("scene_node_border_bottom", "1px", "");
static MagicsParameter<string> scene_node_border_left("scene_node_border_left", "1px", "");
static MagicsParameter<string> scene_node_border_right("scene_node_border_right", "1px", "");
static MagicsParameter<string> scene_node_border("scene_node_border", "off", "");
static MagicsParameter<string> scene_node_border_top("scene_node_border_top", "1px", "");
static MagicsParameter<int> scene_node_border_thickness("scene_node_border_thickness", 1, "");
static MagicsParameter<string> scene_node_padding_bottom("scene_node_padding_bottom", "0%", "");
static MagicsParameter<string> scene_node_padding_left("scene_node_padding_left", "0%", "");
static MagicsParameter<string> scene_node_padding_right("scene_node_padding_right", "0%", "");
static MagicsParameter<string> scene_node_padding_top("scene_node_padding_top", "0%", "");
static MagicsParameter<string> view_display("view_display", "inline", ""); 
static MagicsParameter<string> scene_node_background_colour("scene_node_background_colour", "none", ""); 
static MagicsParameter<string> scene_node_border_colour("scene_node_border_colour", "blue", ""); 
static MagicsParameter<string> scene_node_border_style("scene_node_border_style", "solid", ""); 
static MagicsParameter<string> scene_node_padding_colour("scene_node_padding_colour", "none", ""); 
static MagicsParameter<string> scene_node_id_line("scene_node_id_line", "on", ""); 
#include "PageID.h"
static SimpleObjectMaker<PageID , NoPageID> pageid_PageID("pageid");
static SimpleObjectMaker<NoPageID , NoPageID> nopageid_NoPageID("nopageid");
