----------------------------------------------------------------------------
-- lm_replica.lua
--
-- Wraps a marker to act as a primary firing synchronized events to its
-- own position, and to any number of (or zero) replica markers' positions.
--
-- API: lmark.synchronized_markers(<marker>, <trigger-function-names>)
--
-- (Some markers may already provide convenience functionality for the
--  synchronized_markers call, so check the relevant marker file.)
--
-- Usage:
-- ------
--
-- You can use synchronized_markers() if you have a marker that
-- performs an activity at random intervals, and you want to apply
-- this marker's effects to multiple locations at the same time.
--
-- As an example, take a fog machine:
-- 1) Create the fog machine as you would normally:
--        local fog = fog_machine {
--                            cloud_type = 'flame',
--                            size = 3, pow_min=2,
--                            pow_max = 5, delay_min = 22, delay_max = 120,
--                          }
--
-- 2) Apply it as a Lua marker to one or more locations, wrapping it
--    with synchronized_markers():
--        lua_marker('m', lmark.synchronized_markers(fog, 'do_fog'))
--    Where 'do_fog' is the name of the trigger method on the
--    underlying marker (here the fog machine) that performs the
--    activity of interest (generating fog at some point). The first
--    parameter of this overridden method must be a dgn.point that
--    specifies where the effect occurs. The method may also take any
--    number of additional parameters.
--
--    You may override multiple methods on the base marker:
--        lmark.synchronized_markers(fog, 'do_fog', 'notify_listener')
--    The only requirement for an overridden method is that it take a
--    dgn.point as its first parameter.
--
-- Internals:
-- ---------
-- synchronized_markers() takes one marker instance, and creates one
-- primary marker (which is based on the given marker instance) and
-- multiple replica markers (which are simple PortalDescriptor markers).
-- The only purpose of the replica markers is to be discoverable by
-- dgn.find_marker_positions_by_prop, given a unique, autogenerated
-- replica id.
--
-- The primary marker operates normally, but calls to any of the trigger
-- methods (say 'do_fog') are intercepted. Every trigger call is performed
-- on the primary's position, and then on all the replicas' positions.
----------------------------------------------------------------------------

util.namespace('lmark')

lmark.replica_cookie = 0
function lmark.next_replica_id()
  local replica_id = "marker_replica" .. lmark.replica_cookie
  lmark.replica_cookie = lmark.replica_cookie + 1
  return replica_id
end
