/*
 * Copyright 2025 Bloomberg LP
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef INCLUDED_BUILDBOXCOMMON_SCHEDULINGMETADATA
#define INCLUDED_BUILDBOXCOMMON_SCHEDULINGMETADATA

#include <build/buildgrid/scheduling.pb.h>
#include <buildboxcommon_protos.h>
#include <string>
namespace buildboxcommon {

/*
 * Helper class to attach scheduling metadata to a gRPC client context.
 */
class SchedulingMetadataGenerator {

  public:
    static const std::string HEADER_NAME;

    SchedulingMetadataGenerator() {};

    void attachSchedulingMetadata(grpc::ClientContext *context) const;

    inline void setSchedulingMetadata(
        build::buildgrid::SchedulingMetadata schedulingMetadata)
    {
        d_schedulingMetadata = std::move(schedulingMetadata);
    }

    inline void setLocalityHint(std::string localityHint)
    {
        d_schedulingMetadata.set_locality_hint(std::move(localityHint));
    }

  private:
    SchedulingMetadata d_schedulingMetadata;
};

} // namespace buildboxcommon

#endif
