;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: foreach %s %t wasm-ctor-eval --ctors=test1,test2,test3 --kept-exports=test1,test2,test3 --quiet -all -S -o - | filecheck %s

;; Similar to gc-cycle.wast, but now there are three exported ctors that we
;; call.

(module
 ;; Multiple independent cycles.
 ;; CHECK:      (type $A (struct (field (mut (ref null $A))) (field i32)))
 (type $A (struct (field (mut (ref null $A))) (field i32)))

 ;; CHECK:      (type $1 (func))

 ;; CHECK:      (type $2 (func (result i32)))

 ;; CHECK:      (global $ctor-eval$global_6 (ref $A) (struct.new $A
 ;; CHECK-NEXT:  (ref.null none)
 ;; CHECK-NEXT:  (i32.const 10)
 ;; CHECK-NEXT: ))

 ;; CHECK:      (global $ctor-eval$global_7 (ref $A) (struct.new $A
 ;; CHECK-NEXT:  (ref.null none)
 ;; CHECK-NEXT:  (i32.const 20)
 ;; CHECK-NEXT: ))

 ;; CHECK:      (global $ctor-eval$global_8 (ref $A) (struct.new $A
 ;; CHECK-NEXT:  (ref.null none)
 ;; CHECK-NEXT:  (i32.const 30)
 ;; CHECK-NEXT: ))

 ;; CHECK:      (global $a (mut (ref null $A)) (global.get $ctor-eval$global_6))
 (global $a (mut (ref null $A)) (ref.null $A))
 ;; CHECK:      (global $b (mut (ref null $A)) (global.get $ctor-eval$global_7))
 (global $b (mut (ref null $A)) (ref.null $A))
 ;; CHECK:      (global $c (mut (ref null $A)) (global.get $ctor-eval$global_8))
 (global $c (mut (ref null $A)) (ref.null $A))

 (func $makeCycle (param $i i32) (result (ref $A))
  (local $x (ref $A))
  (local.set $x
   (struct.new $A
    (ref.null $A)
    (local.get $i)
   )
  )
  (struct.set $A 0
   (local.get $x)
   (local.get $x)
  )
  (local.get $x)
 )

 (func $test1 (export "test1")
  (global.set $a
   (call $makeCycle
    (i32.const 10)
   )
  )
 )

 (func $test2 (export "test2")
  (global.set $b
   (call $makeCycle
    (i32.const 20)
   )
  )
 )

 (func $test3 (export "test3")
  (global.set $c
   (call $makeCycle
    (i32.const 30)
   )
  )
 )

 ;; CHECK:      (export "test1" (func $test1_6))

 ;; CHECK:      (export "test2" (func $test2_7))

 ;; CHECK:      (export "test3" (func $test3_8))

 ;; CHECK:      (export "keepalive" (func $keepalive))

 ;; CHECK:      (start $start)

 ;; CHECK:      (func $keepalive (type $2) (result i32)
 ;; CHECK-NEXT:  (i32.add
 ;; CHECK-NEXT:   (struct.get $A 1
 ;; CHECK-NEXT:    (global.get $a)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (struct.get $A 1
 ;; CHECK-NEXT:     (global.get $b)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (struct.get $A 1
 ;; CHECK-NEXT:     (global.get $c)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $keepalive (export "keepalive") (result i32)
  (i32.add
   (struct.get $A 1
    (global.get $a)
   )
   (i32.add
    (struct.get $A 1
     (global.get $b)
    )
    (struct.get $A 1
     (global.get $c)
    )
   )
  )
 )
)
;; CHECK:      (func $start (type $1)
;; CHECK-NEXT:  (struct.set $A 0
;; CHECK-NEXT:   (global.get $ctor-eval$global_6)
;; CHECK-NEXT:   (global.get $ctor-eval$global_6)
;; CHECK-NEXT:  )
;; CHECK-NEXT:  (struct.set $A 0
;; CHECK-NEXT:   (global.get $ctor-eval$global_7)
;; CHECK-NEXT:   (global.get $ctor-eval$global_7)
;; CHECK-NEXT:  )
;; CHECK-NEXT:  (struct.set $A 0
;; CHECK-NEXT:   (global.get $ctor-eval$global_8)
;; CHECK-NEXT:   (global.get $ctor-eval$global_8)
;; CHECK-NEXT:  )
;; CHECK-NEXT: )

;; CHECK:      (func $test1_6 (type $1)
;; CHECK-NEXT:  (nop)
;; CHECK-NEXT: )

;; CHECK:      (func $test2_7 (type $1)
;; CHECK-NEXT:  (nop)
;; CHECK-NEXT: )

;; CHECK:      (func $test3_8 (type $1)
;; CHECK-NEXT:  (nop)
;; CHECK-NEXT: )
