/*
 *   Copyright (C) 2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "SunAndMoon.h"

#include <wx/datetime.h>

#include "common/Locator.h"
#include "common/Moon.h"
#include "common/Sun.h"

int main(int argc, char *argv[])
{
	if (argc < 3) {
		fprintf(stderr, "Usage: SunAndMoon <locator> <frequency>\n");
		return 1;
	}

	wxString locator = wxString(argv[1]);
	int    frequency = ::atoi(argv[2]);

	CSunAndMoon sunAndMoon(locator, frequency);
	sunAndMoon.run();

	return 0;
}

CSunAndMoon::CSunAndMoon(const wxString& locator, int frequency) :
m_locator(locator),
m_frequency(frequency)
{
}

CSunAndMoon::~CSunAndMoon()
{
}

void CSunAndMoon::run()
{
	CLocator locator(m_locator);
	double lat = locator.getLatitude();
	double lon = locator.getLongitude();

	CSun sun;
	CMoon moon;

	sun.setLocation(lat, lon, 150.0);
	moon.setLocation(lat, lon);
	moon.setFrequency(double(m_frequency));

	wxDateTime now = wxDateTime::Now();
	double dayNum = moon.getDayNum(now);

	sun.findSun(dayNum);
	moon.findMoon(dayNum);

	wxString dateTime = now.Format("%d.%m.%Y %H:%M:%S", wxDateTime::UTC);
	printf("Sun and Moon tracking for %s in %s, %.4fN %.4fE\n", dateTime.c_str(), m_locator.c_str(), lat, lon);

	printf("\t\tSun\t\t\tMoon\n");
	printf("Azimuth\t\t%.2f\t\t\t%.2f\n", sun.getAzimuth(), moon.getAzimuth());
	printf("Elevation\t%.2f\t\t\t%.2f\n", sun.getElevation(), moon.getElevation());
	printf("RA:\t\t%.2f\t\t\t%.2f\n", sun.getRA(), moon.getRA());
	printf("Declination\t%.2f\t\t\t%.2f\n", sun.getDec(), moon.getDec());
	printf("LHA\t\t\t\t\t%.2f\n", moon.getLHA());
	printf("GHA\t\t\t\t\t%.2f\n", moon.getGHA());
	printf("Range\t\t\t\t\t%.0f\n", moon.getRange());
	printf("Doppler\t\t\t\t\t%.1f\n", moon.getDoppler());
	printf("Path Loss\t\t\t\t%.1f\n", moon.getPathLoss());
}
