/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FSK441Transmit.h"

#include "common/NCO.h"
#include "common/SoundFile.h"
#include "common/Exception.h"

#include "fsk441/FSK441Defs.h"
#include "fsk441/FSK441Lookups.h"

#include <wx/datetime.h>
#include <wx/debug.h>
#include <wx/log.h>

int main(int argc, char **argv)
{
	if (argc < 3) {
		::fprintf(stderr, "Usage: FSK441Transmit <filename> <message>\n");
		return 0;
	}

	wxString fileName = wxString(argv[1]);
	wxString message  = wxString(argv[2]);

	try {
		ISoundDev* soundDev = new CSoundFile(fileName, FSK441_SAMPLE_RATE, 8);

		CFSK441Transmit transmit(soundDev, message);
		transmit.run();
	}
	catch (CException& ex) {
		::fprintf(stderr, "Error: %s\n", ex.getMessage().c_str());
		return 1;
	}

	catch (...) {
		::fprintf(stderr, "An Exception has occurred\n");
		return 1;
	}

	return 0;
}

CFSK441Transmit::CFSK441Transmit(ISoundDev* soundDev, const wxString& message) :
m_soundDev(soundDev),
m_message(message)
{
	wxASSERT(m_soundDev != NULL);
}

CFSK441Transmit::~CFSK441Transmit()
{
}

void CFSK441Transmit::run()
{
	wxASSERT(m_soundDev != NULL);

	m_soundDev->openWrite();

	CFSK441Lookups lookups;
	CNCO nco(FSK441_SAMPLE_RATE, FSK441_SEND_VOLUME);

	unsigned int charPos = 0;

	for (int samples = 0; samples < (29 * FSK441_SAMPLE_RATE); samples += (3 * FSK441_SYMBOL_LENGTH)) {
		int t1, t2, t3;
		bool ret = lookups.lookupChar(m_message.GetChar(charPos), t1, t2, t3);

		charPos = (charPos + 1) % m_message.Length();

		if (!ret)
			lookups.lookupChar(wxT(" "), t1, t2, t3);

		double freq, out[FSK441_SYMBOL_LENGTH];

		freq = double(t1 + 2) * double(FSK441_SAMPLE_RATE) / double(FSK441_SYMBOL_LENGTH);
		nco.generate(freq, out, FSK441_SYMBOL_LENGTH);
		m_soundDev->write(out, FSK441_SYMBOL_LENGTH);

		freq = double(t2 + 2) * double(FSK441_SAMPLE_RATE) / double(FSK441_SYMBOL_LENGTH);
		nco.generate(freq, out, FSK441_SYMBOL_LENGTH);
		m_soundDev->write(out, FSK441_SYMBOL_LENGTH);

		freq = double(t3 + 2) * double(FSK441_SAMPLE_RATE) / double(FSK441_SYMBOL_LENGTH);
		nco.generate(freq, out, FSK441_SYMBOL_LENGTH);
		m_soundDev->write(out, FSK441_SYMBOL_LENGTH);
	}

	m_soundDev->close();
}
