/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "TransmitControl.h"

const int BORDER_SIZE = 5;

CTransmitControl::CTransmitControl(wxWindow* parent, int id, bool txFirst, bool txEnable) :
wxPanel(parent, id),
m_choice(NULL)
{
	wxStaticBoxSizer* sizer = new wxStaticBoxSizer(new wxStaticBox(this, -1, wxT("Transmit")), wxVERTICAL);

	m_choice = new wxChoice(this, Choice_TX_Order, wxDefaultPosition, wxSize(100, -1));
	m_choice->Append(wxT("First"), (void *)Transmit_First);
	m_choice->Append(wxT("Second"), (void *)Transmit_Second);
	m_choice->SetSelection(txFirst ? Transmit_First : Transmit_Second);
	sizer->Add(m_choice, 0, wxALL, BORDER_SIZE);

	wxCheckBox* enableButton = new wxCheckBox(this, Button_TX_Enable, wxT("TX Enable"));
	enableButton->SetValue(txEnable);
	sizer->Add(enableButton, 0, wxALL, BORDER_SIZE);

	SetSizer(sizer);

	sizer->SetSizeHints(this);
}

CTransmitControl::~CTransmitControl()
{
}
