/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef Receive_H
#define	Receive_H

#include "Thread.h"

enum EWho {
	RX_FIRST,
	RX_SECOND,
	RX_FILE
};

class CReceive : public CThread {

    public:
	CReceive(const wxString& name, EWho who);
	virtual ~CReceive();

	virtual void setRecord(bool record);
	virtual bool isRecording() const;
	virtual EWho getWho() const;

    private:
	bool m_record;
	EWho m_who;
};

#endif
