/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	Average_H
#define	Average_H

class CAverage {

    public:
	CAverage();
	virtual ~CAverage();

	virtual int    getToken() const;
	virtual int    getCount() const;
	virtual double getTotal() const;
	virtual double getAverage() const;
	virtual double getMaximum() const;
	virtual double getMinimum() const;

	virtual void   setToken(int token);
	virtual void   addValue(double value);
	virtual void   subtractValue(double value);
	virtual void   clear();

    private:
    	int    m_token;
	double m_total;
	int    m_count;
	double m_maximum;
	double m_minimum;
};

#endif
