/* guielement.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: guielement.cc,v 1.19 2004/10/27 20:38:33 ralf Exp $ */

#include "guielement.h"
#include "awindow.h"

const char *GUIElement::type="GUIElement";

GUIElement::GUIElement(AGUIX *taguix)
{
  this->aguix=taguix;
  x=0;
  y=0;
  w=1;
  h=1;
  win=0;
  parent=NULL;
  focus=false;
  canHandleFocus = false;
  acceptFocus = false;
  visible = false;
}

GUIElement::~GUIElement()
{
  if(parent!=NULL) {
    parent->remove( this );
  }
}

void GUIElement::move(int tx,int ty)
{
  this->x=tx;
  this->y=ty;
  if(parent!=NULL) {
    parent->moveSubWin(win,tx,ty);
    redraw();
  }
}

void GUIElement::resize(int tw,int th)
{
  if((tw<1)||(th<1)) return;
  this->w=tw;
  this->h=th;
  if(parent!=NULL) {
    parent->resizeSubWin(win,tw,th);
    redraw();
  }
}

void GUIElement::redraw()
{
}

void GUIElement::flush()
{
}

const char *GUIElement::getType() const
{
  return type;
}

bool GUIElement::isType(const char *qtype) const
{
  if(strcmp(type,qtype)==0) return true;
  return false;
}

bool GUIElement::handleMessage(XEvent *E,Message *msg)
{
  // true falls die Message interessiert
  // false wenn nicht
  return false;
}

void GUIElement::getPos(int *tx,int *ty) const
{
  if ( tx != NULL ) *tx = this->x;
  if ( ty != NULL ) *ty = this->y;
}

void GUIElement::getSize(int *tw,int *th) const
{
  if ( tw != NULL ) *tw = this->w;
  if ( th != NULL ) *th = this->h;
}

void GUIElement::setParent(AWindow *tparent)
{
  AWindow *tw;

  if ( tparent != NULL ) {
    if ( parent != NULL ) {
      // only when different parent
      if ( parent != tparent ) {
	setParent( NULL );
	setParent( tparent );
      }
    } else {
      this->parent=tparent;
      doCreateStuff();
      visible = true;
      parent->add( this ); /* add this element to the parent window
			    * when called from outside we have to do this
			    * add will do nothing if this is already in his list
			    * add will call setParent again, but because we already setted parent
			    * this won't be executed twice */
      if ( acceptFocus == true )
	registerFocusElement();
    }
  } else {
    if ( parent != NULL ) {
      doDestroyStuff();
      visible = false;
      if ( acceptFocus == true )
	unregisterFocusElement();
      tw = parent;
      parent = NULL;
      tw->remove( this );  /* remove from parent window because this can be called from outside
			    * because I set parent = NULL this won't be executed twice!
			    */
    }
  }
}

bool GUIElement::hasWin(Window twin) const
{
  if ( parent != NULL ) {
    if(this->win==twin) return true;
  }
  return false;
}

Window GUIElement::getWindow() const
{
  return win;
}

int GUIElement::getWidth() const
{
  return w;
}

int GUIElement::getHeight() const
{
  return h;
}

void GUIElement::toBack()
{
  if ( parent == NULL ) return;
  aguix->WindowtoBack(win);
}

void GUIElement::toFront()
{
  if ( parent == NULL ) return;
  aguix->WindowtoFront(win);
}

int GUIElement::getX() const
{
  return x;
}

int GUIElement::getY() const
{
  return y;
}

bool GUIElement::isParent(Window twin) const
{
  if ( parent != NULL ) {
    if(this->win==twin) return true;
  }
  return false;
}

void GUIElement::paste(unsigned char*buf)
{
}

void GUIElement::cancelpaste()
{
}

void GUIElement::cancelcut()
{
}

void GUIElement::takeFocus()
{
  if ( getAcceptFocus() == true ) {
    if(focus==false) {
      if(parent!=NULL) {
        if(parent->isOwner(this)==true) {
  	  // we are already the owner
   	  // do nothing
        } else {
 	  parent->applyFocus(this);
        }
        focus=true;
        redraw();
      }
    }
  }
}

void GUIElement::leaveFocus()
{
  focus=false;
  if(parent!=NULL) {
    if(parent->isOwner(this)==true) {
      // we have the focus
      // so remove it from the awindow
      parent->invalidFocus();
    } else {
      // we are not the owner
      // so do nothing
    }
  }
  redraw();
}

bool GUIElement::hasFocus() const
{
  return focus;
}

void GUIElement::hide()
{
  if ( parent != NULL ) {
    if ( visible == true ) {
      parent->hide( win );
      visible = false;
    }
  }
}

void GUIElement::show()
{
  if ( parent != NULL ) {
    if ( visible == false ) {
      parent->show( win );
      visible = true;
    }
  }
}

void GUIElement::doCreateStuff()
{
  if ( win == 0 ) {
    win = parent->getSubWindow( 0, x, y, w, h );
  }
}

void GUIElement::doDestroyStuff()
{
  if ( win != 0 ) {
    parent->removeSubWin( win );
    win = 0;
  }
}

void GUIElement::setAcceptFocus( bool nv )
{
  if ( canHandleFocus == true ) {
    if ( nv != acceptFocus ) {
      acceptFocus = nv;
      if ( nv == false ) {
        if ( hasFocus() == true ) {
          leaveFocus();
        }
	unregisterFocusElement();
      } else {
	registerFocusElement();
      }
    }
  }
}

bool GUIElement::getAcceptFocus() const
{
  return acceptFocus;
}

void GUIElement::registerFocusElement()
{
  if ( parent != NULL ) {
    parent->registerFocusElement( this );
  }
}

void GUIElement::unregisterFocusElement()
{
  if ( parent != NULL ) {
    parent->unregisterFocusElement( this );
  }
}

bool GUIElement::isVisible() const
{
  if ( visible == false ) return false;
  else {
    if ( parent != NULL ) {
      if ( parent->isVisible() == true ) return true;
      else return false;
    } else {
      return false;
    }
  }
}

int GUIElement::handleMessageLock( XEvent *E, Message *msg )
{
  int res = 0;

  if ( ( E == NULL ) || ( msg == NULL ) ) return -1;

  // give msg to real handler if
  // 1.is the lock element
  // 2.the lock element is null
  // 3.or it's an expose msg (but then only the first time)
  if ( ( msg->lockElement == this ) ||
       ( msg->lockElement == NULL ) ||
       ( ( msg->type == Expose ) && ( msg->loop == 0 ) ) ) {
    res = ( handleMessage( E, msg ) == true ) ? 1 : 0;
  }
  return res;
}
