/* wconfig_dcd.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2006,2011 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "wconfig_dcd.hh"
#include "wconfig.h"
#include "worker.h"
#include "worker_locale.h"
#include <aguix/fieldlistview.h>
#include <aguix/button.h>
#include <aguix/choosebutton.h>
#include "simplelist.hh"
#include "datei.h"

DCDPanel::DCDPanel( AWindow &basewin, WConfig &baseconfig ) : WConfigPanel( basewin, baseconfig )
{
  filv = NULL;
  cb = NULL;
}

DCDPanel::~DCDPanel()
{
}

int DCDPanel::create()
{
  Panel::create();

  int trow;
  int pos;
  int id;
  char *tstr;

  AContainer *ac1 = setContainer( new AContainer( this, 1, 4 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  addMultiLineText( catalog.getLocale( 684 ),
                    *ac1,
                    0, 0,
                    NULL, NULL );

  filv =(FieldListView*)ac1->add( new FieldListView( _aguix, 0, 0, 100, 100, 0 ), 0, 1, AContainer::CO_MIN );
  filv->setHBarState(2);
  filv->setVBarState(2);

  AContainer *ac1_1 = ac1->add( new AContainer( this, 3, 1 ), 0, 2 );
  ac1_1->setMinSpace( 0 );
  ac1_1->setMaxSpace( 0 );
  ac1_1->setBorderWidth( 0 );

  newb = (Button*)ac1_1->add( new Button( _aguix, 0, 0, catalog.getLocale( 181 ), 1, 0, 0 ),
			      0, 0, AContainer::CO_INCW );
  newb->connect( this );
  delb = (Button*)ac1_1->add( new Button( _aguix, 0, 0, catalog.getLocale( 183 ), 1, 0, 0 ),
			      1, 0, AContainer::CO_INCW );
  delb->connect( this );
  editb = (Button*)ac1_1->add( new Button( _aguix, 0, 0, catalog.getLocale( 182 ), 1, 0, 0 ),
			       2, 0, AContainer::CO_INCW );
  editb->connect( this );

  cb = (ChooseButton*)ac1->add( new ChooseButton( _aguix, 0, 0, _baseconfig.getDontCheckVirtual(),
						  catalog.getLocale( 619 ), LABEL_RIGHT, 1, 0 ),
				0, 3, AContainer::CO_INCWNR );

  contMaximize( true );

  id= _baseconfig.getDontCheckDirs()->initEnum();
  tstr=(char*)_baseconfig.getDontCheckDirs()->getFirstElement(id);
  pos=0;
  while(tstr!=NULL) {
    trow = filv->addRow();
    filv->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
    filv->setText( trow, 0, tstr );
    filv->setData( trow, pos++ );
    tstr=(char*)_baseconfig.getDontCheckDirs()->getNextElement(id);
  }
  filv->redraw();
  _baseconfig.getDontCheckDirs()->closeEnum(id);
  return 0;
}

int DCDPanel::saveValues()
{
  if ( filv == NULL || cb == NULL ) return 1;
  
  List *dontcheckdirs = _baseconfig.getDontCheckDirs();

  int id = dontcheckdirs->initEnum();

  char *tstr = (char*)dontcheckdirs->getFirstElement( id );
  while ( tstr != NULL ) {
    _freesafe( tstr );
    tstr = (char*)dontcheckdirs->getNextElement( id );
  }
  dontcheckdirs->closeEnum( id );
  dontcheckdirs->removeAllElements();

  int trow = 0;
  while ( filv->isValidRow( trow ) == true ) {
    dontcheckdirs->addElement( dupstring( filv->getText( trow, 0 ).c_str() ) );
    trow++;
  }
  
  _baseconfig.setDontCheckVirtual( cb->getState() );
  return 0;
}

void DCDPanel::run( Widget *elem, AGMessage &msg )
{
  char *tstr,*buttonstr,*tstr2;
  const char *textstr;
  bool found;
  int trow, trow2;

  if ( msg.type == AG_BUTTONCLICKED ) {
    if ( msg.button.button == newb ) {
      textstr=catalog.getLocale(199);
      buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(11))+1+
				  strlen(catalog.getLocale(8))+1);
      sprintf(buttonstr,"%s|%s",catalog.getLocale(11),
	      catalog.getLocale(8));
      if ( string_request( catalog.getLocale( 123 ), textstr, "", buttonstr, &tstr ) == 0 ) {
	if(strlen(tstr)>0) {
	  if(tstr[0]=='/') {
	    tstr2=HandlePath(tstr);
	    
	    found=false;
	    trow = 0;
	    while ( filv->isValidRow( trow ) == true ) {
	      if ( strcmp( filv->getText( trow, 0 ).c_str(), tstr2 ) == 0 ) {
		found = true;
		break;
	      }
	      trow++;
	    }
	    if(found==false) {
	      trow = filv->addRow();
	      filv->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
	      filv->setText( trow, 0, tstr2 );
	      filv->setActiveRow( trow );
	      filv->showActive();
	      filv->redraw();
	    }
	    _freesafe(tstr2);
	  }
	}
	_freesafe(tstr);
      } else _freesafe(tstr);
      _freesafe(buttonstr);
    } else if(msg.button.button==delb) {
      trow = filv->getActiveRow();
      if ( filv->isValidRow( trow ) == true ) {
	filv->deleteRow( trow );
	filv->redraw();
      }
    } else if(msg.button.button==editb) {
      trow = filv->getActiveRow();
      if ( filv->isValidRow( trow ) == true ) {
	textstr=catalog.getLocale(199);
	buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(11))+1+
				    strlen(catalog.getLocale(8))+1);
	sprintf(buttonstr,"%s|%s",catalog.getLocale(11),
		catalog.getLocale(8));
	if ( string_request( catalog.getLocale( 123 ),
                             textstr,
                             filv->getText( trow, 0 ).c_str(),
                             buttonstr,
                             &tstr ) == 0 ) {
	  if(strlen(tstr)>0) {
	    if(tstr[0]=='/') {
	      tstr2=HandlePath(tstr);
	      
	      found=false;
	      trow2 = 0;
	      while ( filv->isValidRow( trow2 ) == true ) {
		if ( strcmp( filv->getText( trow2, 0 ).c_str(), tstr2 ) == 0 ) {
		  found=true;
		  break;
		}
		trow2++;
	      }
	      if(found==false) {
		filv->setText( trow, 0, tstr2 );
		filv->redraw();
	      }
	      _freesafe(tstr2);
	    }
	  }
	  _freesafe(tstr);
	} else _freesafe(tstr);
	_freesafe(buttonstr);
      }
    }
  }
}
