/* cursorops.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2001-2007,2009 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "cursorops.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"
#include "wpucontext.h"
#include "ownop.h"
#include "fileentry.hh"

/******
 RowUp
*******/

const char *RowUp::name="RowUp";

bool RowUp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *RowUp::getName()
{
  return name;
}

RowUp::RowUp() : FunctionProto()
{
}

RowUp::~RowUp()
{
}

RowUp *RowUp::duplicate() const
{
  RowUp *ta=new RowUp();
  return ta;
}

int RowUp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->up();
        }
      }
    }
  }
  return 0;
}

const char *RowUp::getDescription()
{
  return catalog.getLocaleCom(5);
}

/*************
 Ende RowUp
**************/

/********
 RowDown
*********/

const char *RowDown::name="RowDown";

bool RowDown::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *RowDown::getName()
{
  return name;
}

RowDown::RowDown() : FunctionProto()
{
}

RowDown::~RowDown()
{
}

RowDown *RowDown::duplicate() const
{
  RowDown *ta=new RowDown();
  return ta;
}

int RowDown::run( WPUContext *wpu, ActionMessage *msg)
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->down();
        }
      }
    }
  }
  return 0;
}

const char *RowDown::getDescription()
{
  return catalog.getLocaleCom(6);
}

/*************
 Ende RowDown
**************/

/********
 FirstRow
*********/

const char *FirstRow::name="FirstRow";

bool FirstRow::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *FirstRow::getName()
{
  return name;
}

FirstRow::FirstRow() : FunctionProto()
{
}

FirstRow::~FirstRow()
{
}

FirstRow *FirstRow::duplicate() const
{
  FirstRow *ta=new FirstRow();
  return ta;
}

int FirstRow::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->top();
        }
      }
    }
  }
  return 0;
}

const char *FirstRow::getDescription()
{
  return catalog.getLocaleCom(9);
}

/*************
 Ende FirstRow
**************/

/********
 LastRow
*********/

const char *LastRow::name="LastRow";

bool LastRow::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *LastRow::getName()
{
  return name;
}

LastRow::LastRow() : FunctionProto()
{
}

LastRow::~LastRow()
{
}

LastRow *LastRow::duplicate() const
{
  LastRow *ta=new LastRow();
  return ta;
}

int LastRow::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->last();
        }
      }
    }
  }
  return 0;
}

const char *LastRow::getDescription()
{
  return catalog.getLocaleCom(10);
}

/*************
 Ende LastRow
**************/

/******
 PageUp
*******/

const char *PageUp::name="PageUp";

bool PageUp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *PageUp::getName()
{
  return name;
}

PageUp::PageUp() : FunctionProto()
{
}

PageUp::~PageUp()
{
}

PageUp *PageUp::duplicate() const
{
  PageUp *ta=new PageUp();
  return ta;
}

int PageUp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->pageup();
        }
      }
    }
  }
  return 0;
}

const char *PageUp::getDescription()
{
  return catalog.getLocaleCom(11);
}

/*************
 Ende PageUp
**************/

/******
 PageDown
*******/

const char *PageDown::name="PageDown";

bool PageDown::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *PageDown::getName()
{
  return name;
}

PageDown::PageDown() : FunctionProto()
{
}

PageDown::~PageDown()
{
}

PageDown *PageDown::duplicate() const
{
  PageDown *ta=new PageDown();
  return ta;
}

int PageDown::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->pagedown();
        }
      }
    }
  }
  return 0;
}

const char *PageDown::getDescription()
{
  return catalog.getLocaleCom(12);
}

/*************
 Ende PageDown
**************/

/******
 SelectOp
*******/

const char *SelectOp::name="SelectOp";

bool SelectOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *SelectOp::getName()
{
  return name;
}

SelectOp::SelectOp() : FunctionProto()
{
}

SelectOp::~SelectOp()
{
}

SelectOp *SelectOp::duplicate() const
{
  SelectOp *ta=new SelectOp();
  return ta;
}

int SelectOp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->select();
        }
      }
    }
  }
  return 0;
}

const char *SelectOp::getDescription()
{
  return catalog.getLocaleCom(13);
}

/*************
 Ende SelectOp
**************/

/******
 SelectAllOp
*******/

const char *SelectAllOp::name="SelectAllOp";

bool SelectAllOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *SelectAllOp::getName()
{
  return name;
}

SelectAllOp::SelectAllOp() : FunctionProto()
{
}

SelectAllOp::~SelectAllOp()
{
}

SelectAllOp *SelectAllOp::duplicate() const
{
  SelectAllOp *ta=new SelectAllOp();
  return ta;
}

int SelectAllOp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->selectall();
        }
      }
    }
  }
  return 0;
}

const char *SelectAllOp::getDescription()
{
  return catalog.getLocaleCom(14);
}

/*************
 Ende SelectAllOp
**************/

/******
 SelectNoneOp
*******/

const char *SelectNoneOp::name="SelectNoneOp";

bool SelectNoneOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *SelectNoneOp::getName()
{
  return name;
}

SelectNoneOp::SelectNoneOp() : FunctionProto()
{
}

SelectNoneOp::~SelectNoneOp()
{
}

SelectNoneOp *SelectNoneOp::duplicate() const
{
  SelectNoneOp *ta=new SelectNoneOp();
  return ta;
}

int SelectNoneOp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->selectnone();
        }
      }
    }
  }
  return 0;
}

const char *SelectNoneOp::getDescription()
{
  return catalog.getLocaleCom(15);
}

/*************
 Ende SelectNoneOp
**************/

/******
  InvertAllOp
*******/

const char *InvertAllOp::name="InvertAllOp";

bool InvertAllOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *InvertAllOp::getName()
{
  return name;
}

InvertAllOp::InvertAllOp() : FunctionProto()
{
}

InvertAllOp::~InvertAllOp()
{
}

InvertAllOp *InvertAllOp::duplicate() const
{
  InvertAllOp *ta=new InvertAllOp();
  return ta;
}

int InvertAllOp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->invertall();
        }
      }
    }
  }
  return 0;
}

const char *InvertAllOp::getDescription()
{
  return catalog.getLocaleCom(16);
}

/*************
 Ende InvertAllOp
**************/

/******
  ParentDirOp
*******/

const char *ParentDirOp::name="ParentDirOp";

bool ParentDirOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *ParentDirOp::getName()
{
  return name;
}

ParentDirOp::ParentDirOp() : FunctionProto()
{
}

ParentDirOp::~ParentDirOp()
{
}

ParentDirOp *ParentDirOp::duplicate() const
{
  ParentDirOp *ta=new ParentDirOp();
  return ta;
}

int ParentDirOp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;

          if ( nm1->filteredSearchActive() == true ) {
              nm1->deactivateFilteredSearch();
          } else {
              nm1->parent();
          }
        }
      }
    }
  }
  return 0;
}

const char *ParentDirOp::getDescription()
{
  return catalog.getLocaleCom(17);
}

/*************
 Ende ParentDirOp
**************/
