/* normalops.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/* $Id: normalops.h,v 1.13 2005/10/19 18:03:40 ralf Exp $ */

#ifndef NORMALOPS_H
#define NORMALOPS_H

#include "wdefines.h"
#include "functionproto.h"
#include <aguix/util.h>

class ChangeListerSetOp:public FunctionProto
{
public:
  ChangeListerSetOp();
  virtual ~ChangeListerSetOp();
  ChangeListerSetOp( const ChangeListerSetOp &other );
  ChangeListerSetOp &operator=( const ChangeListerSetOp &other );

  virtual ChangeListerSetOp *duplicate() const;
  virtual int configure();
  virtual bool isName(const char *);
  virtual const char *getName();
#if ! ( defined ( __GNUC__ ) && ( __GNUC__ < 3 ) )
  using FunctionProto::run;
#endif
  virtual int run( WPUContext *wpu, ActionMessage* );
  virtual const char *getDescription();
  virtual bool save(Datei *);

  enum { CLS_LEFT_LISTER,CLS_RIGHT_LISTER,CLS_CURRENT_LISTER,CLS_OTHER_LISTER};
  void setMode(int);
protected:
  static const char *name;
  int mode;
};

class SwitchListerOp:public FunctionProto
{
public:
  SwitchListerOp();
  virtual ~SwitchListerOp();
  SwitchListerOp( const SwitchListerOp &other );
  SwitchListerOp &operator=( const SwitchListerOp &other );

  virtual SwitchListerOp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
#if ! ( defined ( __GNUC__ ) && ( __GNUC__ < 3 ) )
  using FunctionProto::run;
#endif
  virtual int run( WPUContext *wpu, ActionMessage* );
  virtual const char *getDescription();
protected:
  static const char *name;
};

class FilterSelectOp:public FunctionProto
{
public:
  FilterSelectOp();
  virtual ~FilterSelectOp();
  FilterSelectOp( const FilterSelectOp &other );
  FilterSelectOp &operator=( const FilterSelectOp &other );

  virtual FilterSelectOp *duplicate() const;
  virtual int configure();
  virtual bool isName(const char *);
  virtual const char *getName();
#if ! ( defined ( __GNUC__ ) && ( __GNUC__ < 3 ) )
  using FunctionProto::run;
#endif
  int run( WPUContext *wpu, ActionMessage* );
  virtual const char *getDescription();
  virtual bool save(Datei *);
  
  bool requestfilter();
  void setFilter( const char *str );
protected:
  static const char *name;
  char *filter;
  char *actual_filter;
  
  void addHistoryItem( const char *str );
  static List *filter_history;
private:
  static int instance_counter;
  static int history_size;
  static int lastw, lasth;
  void initHistory();
  void closeHistory();
};

class FilterUnSelectOp:public FilterSelectOp
{
public:
  FilterUnSelectOp();
  virtual ~FilterUnSelectOp();
  FilterUnSelectOp( const FilterUnSelectOp &other );
  FilterUnSelectOp &operator=( const FilterUnSelectOp &other );

  virtual FilterUnSelectOp *duplicate() const;
  virtual int configure();
  virtual bool isName(const char *);
  virtual const char *getName();
#if ! ( defined ( __GNUC__ ) && ( __GNUC__ < 3 ) )
  using FunctionProto::run;
#endif
  virtual int run( WPUContext *wpu, ActionMessage* );
  virtual const char *getDescription();
  
  bool requestfilter();
protected:
  static const char *name;
};

class Path2OSideOp:public FunctionProto
{
public:
  Path2OSideOp();
  virtual ~Path2OSideOp();
  Path2OSideOp( const Path2OSideOp &other );
  Path2OSideOp &operator=( const Path2OSideOp &other );

  virtual Path2OSideOp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
#if ! ( defined ( __GNUC__ ) && ( __GNUC__ < 3 ) )
  using FunctionProto::run;
#endif
  virtual int run( WPUContext *wpu, ActionMessage* );
  virtual const char *getDescription();
protected:
  static const char *name;
};

class QuitOp:public FunctionProto
{
public:
  QuitOp();
  virtual ~QuitOp();
  QuitOp( const QuitOp &other );
  QuitOp &operator=( const QuitOp &other );

  virtual QuitOp *duplicate() const;
  virtual int configure();
  virtual bool isName(const char *);
  virtual const char *getName();
#if ! ( defined ( __GNUC__ ) && ( __GNUC__ < 3 ) )
  using FunctionProto::run;
#endif
  virtual int run( WPUContext *wpu, ActionMessage* );
  virtual const char *getDescription();
  virtual bool save(Datei *);
  
  void setMode(int);
  enum {Q_NORMAL_QUIT,Q_QUICK_QUIT};
protected:
  static const char *name;
  int mode;
};

#endif

