/* dirbookmarkeditui.hh
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2008 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef DIRBOOKMARKEDITUI_HH
#define DIRBOOKMARKEDITUI_HH

#include <memory>
#include <string>

#include "bookmarkdb.hh"

class DirBookmarkEditUI
{
public:
    DirBookmarkEditUI( class AGUIX &aguix, class BookmarkDB &data,
                       class BookmarkDBEntry &entry );
    ~DirBookmarkEditUI();

    int mainLoop();
private:
    class AGUIX &m_aguix;
    class BookmarkDB &m_data;
    class BookmarkDBEntry &m_entry;
    
    std::auto_ptr<class AWindow> m_win;
    class Button *m_okb;
    class Button *m_cancelb;
    class StringGadget *m_name_sg, *m_alias_sg;
    class ChooseButton *m_useparent_cb;
};

#endif
