/* intviewop.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: intviewop.h,v 1.2 2005/08/17 06:29:59 ralf Exp $ */

#ifndef INTVIEWOP_H
#define INTVIEWOP_H

#include "wdefines.h"
#include "functionproto.h"
#include <string>
#include <list>

class InternalViewOp : public FunctionProto
{
public:
  InternalViewOp();
  ~InternalViewOp();
  InternalViewOp( const InternalViewOp &other );
  InternalViewOp &operator=( const InternalViewOp &other );

  InternalViewOp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
#if ! ( defined ( __GNUC__ ) && ( __GNUC__ < 3 ) )
  using FunctionProto::run;
#endif
  int run( WPUContext*, ActionMessage* );
  bool save(Datei*);
  virtual const char *getDescription();
  int configure();
  
  int doconfigure( int mode );
  
  typedef enum { SHOW_ACTIVE_FILE,
		 SHOW_CUSTOM_FILES } show_file_mode_t;

  void setRequestFlags( bool );
  void setShowFileMode( show_file_mode_t );
  void setCustomFiles( std::string );

  static const char *name;
protected:
  void view( std::list<std::string> &filelist ) const;
  void buildTextView( std::string &filename,
		      class TextStorageFile **ts,
		      class TextView **tv,
		      class AContainer *ac1,
		      class Text *fnt,
		      class AWidth &lencalc ) const;
  // Infos to save

  show_file_mode_t _mode;
  std::string _custom_files;
  bool _request_flags;
  
  // temp variables
  show_file_mode_t _tmode;
  std::string _tcustom_files;
};

#endif
