/**************************************************************************
* This file is part of the WebIssues Desktop Client program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2014 WebIssues Team
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
**************************************************************************/

#include "metadataeditorfactory.h"
#include "metadataeditors.h"

AbstractMetadataEditor* MetadataEditorFactory::createMetadataEditor( AttributeType type, QObject* parent, QWidget* parentWidget )
{
    switch ( type ) {
        case TextAttribute:
            return new TextMetadataEditor( parent, parentWidget );
        case EnumAttribute:
            return new EnumMetadataEditor( parent, parentWidget );
        case NumericAttribute:
            return new NumericMetadataEditor( parent, parentWidget );
        case DateTimeAttribute:
            return new DateTimeMetadataEditor( parent, parentWidget );
        case UserAttribute:
            return new UserMetadataEditor( parent, parentWidget );
        default:
            return NULL;
    }
}
