/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef ISSUEVIEWSETTINGS_H
#define ISSUEVIEWSETTINGS_H

#include <QObject>
#include <QMap>

class QSettings;

class DefinitionInfo;

/**
* Class for saving and restoring issue view settings.
*/
class IssueViewSettings : public QObject
{
    Q_OBJECT
public:
    /**
    * Default constructor.
    */
    IssueViewSettings();

    /**
    * Destructor.
    */
    ~IssueViewSettings();

public:
    /**
    * Read settings for the view.
    */
    void openIssueView( int typeId );

    /**
    * Return a list of attributes in the view.
    */
    QList<int> loadAttributes();

    /**
    * Set the list of attributes for the view.
    */
    void saveAttributes( const QList<int>& attributes );

private:
    QStringList serializeAttributes( const QList<int>& attributes );
    QList<int> deserializeAttributes( const QStringList& list );

private:
    int m_typeId;
};

#endif
