/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef COLUMNSETTINGSDIALOG_H
#define COLUMNSETTINGSDIALOG_H

#include <QDialog>

class QLabel;
class QToolButton;
class QListWidget;
class QComboBox;
class QDialogButtonBox;

/**
* Dialog for modifying column settings for a list.
*/
class ColumnSettingsDialog : public QDialog
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    ColumnSettingsDialog( QWidget* parent );

    /**
    * Destructor.
    */
    ~ColumnSettingsDialog();

public:
    /**
    * Set the prompt text.
    */
    void setPrompt( const QString& text );

    /**
    * Set a list of all available columns.
    */
    void setAvailableColumns( const QList<int>& columns );

    /**
    * Set the default list of columns.
    */
    void setDefaultColumns( const QList<int>& columns );

    /**
    * Set the list of fixed columns.
    *
    * Fixed columns cannot be removed from the list.
    */
    void setFixedColumns( const QList<int>& columns );

    /**
    * Initialize the dialog with a list of columns.
    */
    void setColumns( const QList<int>& columns );

    /**
    * Read the list of columns from the dialog.
    */
    QList<int> columns() const;

    /**
    * Set the default sort order.
    */
    void setDefaultSortOrder( const QPair<int, Qt::SortOrder>& order );

    /**
    * Initialize the dialog with a sort order.
    */
    void setSortOrder( const QPair<int, Qt::SortOrder>& order );

    /**
    * Read the sort order from the dialog.
    */
    QPair<int, Qt::SortOrder> sortOrder();

signals:
    /**
    * Emitted when the Ok or Apply button is clicked.
    */
    void settingsApplied();

public: // overrides
    void accept();

private slots:
    void restoreDefaults();

    void availableSelected();
    void currentSelected();

    void addClicked();
    void removeClicked();
    void upClicked();
    void downClicked();

private:
    void moveItem( int offset );

private:
    QList<int> m_availableColumns;
    QList<int> m_defaultColumns;

    QList<int> m_fixedColumns;

    QPair<int, Qt::SortOrder> m_defaultOrder;

    QLabel* m_promptLabel;

    QListWidget* m_availableList;
    QListWidget* m_currentList;

    QToolButton* m_addButton;
    QToolButton* m_removeButton;
    QToolButton* m_upButton;
    QToolButton* m_downButton;

    QComboBox* m_sortCombo;
    QComboBox* m_orderCombo;

    QDialogButtonBox* m_buttonBox;
};

#endif
