/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef ATTRIBUTESETTINGSDIALOG_H
#define ATTRIBUTESETTINGSDIALOG_H

#include <QDialog>

class QLabel;
class QToolButton;
class QListWidget;
class QDialogButtonBox;

/**
* Dialog for modifying attribute settings.
*/
class AttributeSettingsDialog : public QDialog
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    AttributeSettingsDialog( QWidget* parent );

    /**
    * Destructor.
    */
    ~AttributeSettingsDialog();

public:
    /**
    * Set the prompt text.
    */
    void setPrompt( const QString& text );

    /**
    * Initialize the dialog with a list of attributes.
    */
    void setAttributes( const QList<int>& attributes );

    /**
    * Read the list of attributes from the dialog.
    */
    QList<int> attributes() const;

signals:
    /**
    * Emitted when the Ok or Apply button is clicked.
    */
    void settingsApplied();

public: // overrides
    void accept();

private slots:
    void itemSelected();

    void upClicked();
    void downClicked();

private:
    QLabel* m_promptLabel;

    QListWidget* m_list;

    QToolButton* m_upButton;
    QToolButton* m_downButton;

    QDialogButtonBox* m_buttonBox;
};

#endif
