/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef ATTACHMENTSCACHE_H
#define ATTACHMENTSCACHE_H

#include <QObject>
#include <QList>

/**
* Class for caching downloaded attachments.
*/
class AttachmentsCache : public QObject
{
    Q_OBJECT
public:
    /**
    * Default constructor.
    */
    AttachmentsCache();

    /**
    * Destructor.
    */
    ~AttachmentsCache();

public:
    /**
    * Find an attachment in the cache.
    *
    * @param attachmentId Identifier of the attachment.
    *
    * @return The path of the attachment file or an empty string.
    */
    QString findAttachment( int attachmentId );

    /**
    * Allocate a path for a new attachment.
    *
    * @param attachmentId Identifier of the attachment.
    * @param name Original name of the attachment.
    * @param size Size of the attachment.
    *
    * @return The path of the attachment file.
    */
    QString allocAttachment( int attachmentId, const QString& name, int size );

    /**
    * Commit the allocated attachment into the cache.
    */
    void commitAttachment();

private:
    void openCache();
    void saveCache();

    void flushCache( int allocated );

    QString generateUniqueName( const QString& name );

private slots:
    void settingsChanged();

private:

private:
    struct Item
    {
        int m_attachmentId;
        QString m_name;
        int m_size;
    };

private:
    QList<Item> m_cachedItems;

    Item m_allocatedItem;
};

#endif
