/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "abstracttablemodel.h"

#include <QPixmap>

#include "data/datamanager.h"
#include "data/updateevent.h"

using namespace WebIssues;

AbstractTableModel::AbstractTableModel( QObject* parent ) : QObject( parent )
{
    dataManager->addObserver( this );
}

AbstractTableModel::~AbstractTableModel()
{
    if ( dataManager )
        dataManager->removeObserver( this );
}

QPixmap AbstractTableModel::icon( int id ) const
{
    return QPixmap();
}

QString AbstractTableModel::toolTip( int id ) const
{
    return QString();
}

int AbstractTableModel::compare( int id1, int id2, Column column ) const
{
    QString text1 = text( id1, column );
    QString text2 = text( id2, column );
    return QString::localeAwareCompare( text1, text2 );
}

void AbstractTableModel::updateEvent( UpdateEvent* e )
{
}

void AbstractTableModel::customEvent( QEvent* e )
{
    if ( e->type() == UpdateEvent::Type )
        updateEvent( (UpdateEvent*)e );
}
