// Displays the size of the page
function webdeveloper_viewDocumentSize()
{
    var calculatedFileSize             = 0;
    var calculatedUncompressedFileSize = 0;
    var countCellDataElement           = null;
    var documentCount                  = 0;
    var documentList                   = webdeveloper_tidyDocuments(webdeveloper_getDocuments(webdeveloper_getContentWindow())).sort(webdeveloper_sortDocumentsByFileSize);
    var documentLength                 = documentList.length;
    var documentURL                    = null;
    var fileSize                       = 0;
    var image                          = null;
    var imageLength                    = null;
    var imageList                      = new Array();
    var oldTab                         = getBrowser().selectedTab;
    var oldURL                         = getBrowser().currentURI.spec;
    var generatedDocument              = webdeveloper_generateDocument("");
    var bodyElement                    = webdeveloper_getDocumentBodyElement(generatedDocument);
    var cellDataElement                = generatedDocument.createElement("td");
    var headElement                    = webdeveloper_getDocumentHeadElement(generatedDocument);
    var headerElement                  = generatedDocument.createElement("h1");
    var linkElement                    = generatedDocument.createElement("link");
    var object                         = null;
    var objectLength                   = null;
    var objectList                     = new Array();
    var pageDocument                   = null;
    var scriptElement                  = null;
    var scriptLength                   = null;
    var scriptList                     = new Array();
    var src                            = null;
    var stringBundle                   = document.getElementById("webdeveloper-string-bundle");
    var styleSheet                     = null;
    var styleSheetLength               = null;
    var styleSheetList                 = new Array();
    var tableElement                   = generatedDocument.createElement("table");
    var tableRowElement                = generatedDocument.createElement("tr");
    var title                          = stringBundle.getFormattedString("webdeveloper_viewDocumentSizeTitle", [oldURL]);
    var totalCellDataElement           = null;
    var totalFileSize                  = 0;
    var totalUncompressedFileSize      = 0;
    var uncompressedLabel              = stringBundle.getString("webdeveloper_uncompressed").toLowerCase();
    var uncompressedFileSize           = 0;

    generatedDocument.title = title;

    webdeveloper_addGeneratedStyles(generatedDocument);

    linkElement.setAttribute("href", "chrome://webdeveloper/content/stylesheets/generated/view_document_size.css");
    linkElement.setAttribute("rel", "stylesheet");
    linkElement.setAttribute("type", "text/css");
    headElement.appendChild(linkElement);

    headerElement.appendChild(generatedDocument.createTextNode(title));
    bodyElement.appendChild(headerElement);

    cellDataElement.setAttribute("class", "pivot");
    tableRowElement.appendChild(cellDataElement);

    countCellDataElement = generatedDocument.createElement("td");

    tableRowElement.appendChild(countCellDataElement);

    totalCellDataElement = generatedDocument.createElement("td");

    totalCellDataElement.setAttribute("class", "size");
    tableRowElement.appendChild(totalCellDataElement);
    tableRowElement.setAttribute("class", "collapsed");
    tableElement.appendChild(tableRowElement);

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument   = documentList[i];
        documentURL    = pageDocument.documentURI;
        imageList      = imageList.concat(webdeveloper_getImagesForDocument(pageDocument, true, true));
        objectList     = objectList.concat(webdeveloper_getObjectsForDocument(pageDocument));
        scriptList     = scriptList.concat(webdeveloper_getScriptsForDocument(pageDocument, false));
        styleSheetList = styleSheetList.concat(webdeveloper_getStyleSheetsForDocument(pageDocument, false, true));

        // If the document is not in the image and object lists
        if(!webdeveloper_mediaArrayContains(imageList, documentURL) && !webdeveloper_mediaArrayContains(objectList, documentURL))
        {
            cellDataElement      = generatedDocument.createElement("td");
            fileSize             = webdeveloper_getFileSize(documentURL);
            linkElement          = generatedDocument.createElement("a");
            tableRowElement      = generatedDocument.createElement("tr");
            uncompressedFileSize = webdeveloper_getUncompressedFileSize(documentURL);

            documentCount++;

            // If the file size is set
            if(fileSize)
            {
                calculatedFileSize += fileSize;
            }

            // If the uncompressed file size is set and different from the file size
            if(uncompressedFileSize && uncompressedFileSize != fileSize)
            {
                calculatedUncompressedFileSize += uncompressedFileSize;
            }
            else
            {
                calculatedUncompressedFileSize += fileSize;
            }

            // If this is an even row
            if(i % 2 == 0)
            {
                tableRowElement.setAttribute("class", "hidden shaded");
            }
            else
            {
                tableRowElement.setAttribute("class", "hidden");
            }

            cellDataElement.setAttribute("class", "indent");
            tableRowElement.appendChild(cellDataElement);

            cellDataElement = generatedDocument.createElement("td");

            linkElement.setAttribute("href", documentURL);
            linkElement.appendChild(generatedDocument.createTextNode(documentURL));
            cellDataElement.appendChild(linkElement);
            tableRowElement.appendChild(cellDataElement);

            cellDataElement = generatedDocument.createElement("td");

            cellDataElement.setAttribute("class", "size");

            // If the uncompressed file size is set and different from the file size
            if(uncompressedFileSize && uncompressedFileSize != fileSize)
            {
                cellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(fileSize) + " (" + webdeveloper_formatFileSize(uncompressedFileSize) + " " + uncompressedLabel + ")"));
            }
            else
            {
                cellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(fileSize)));
            }

            tableRowElement.appendChild(cellDataElement);
            tableElement.appendChild(tableRowElement);
        }
    }

    // If there is one document
    if(documentCount == 1)
    {
        countCellDataElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_documents") + " (" + documentCount + " " + stringBundle.getString("webdeveloper_file").toLowerCase() + ")"));
    }
    else
    {
        countCellDataElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_documents") + " (" + documentCount + " " + stringBundle.getString("webdeveloper_files").toLowerCase() + ")"));
    }

    // If the calculated file size and calculated uncompressed file size are set and different
    if(calculatedFileSize && calculatedUncompressedFileSize && calculatedFileSize != calculatedUncompressedFileSize)
    {
        totalCellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(calculatedFileSize) + " (" + webdeveloper_formatFileSize(calculatedUncompressedFileSize) + " " + uncompressedLabel + ")"));
    }
    else
    {
        totalCellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(calculatedFileSize)));
    }

    totalFileSize             += calculatedFileSize;
    totalUncompressedFileSize += calculatedUncompressedFileSize;

    calculatedFileSize = 0;
    cellDataElement   = generatedDocument.createElement("td");
    imageList         = webdeveloper_setImageFileSizes(webdeveloper_tidyImages(imageList)).sort(webdeveloper_sortImagesByFileSize);
    imageLength       = imageList.length;
    tableRowElement   = generatedDocument.createElement("tr");

    cellDataElement.setAttribute("class", "pivot");
    tableRowElement.appendChild(cellDataElement);

    cellDataElement = generatedDocument.createElement("td");

    // If there is one image
    if(imageLength == 1)
    {
        cellDataElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_images") + " (" + imageLength + " " + stringBundle.getString("webdeveloper_file").toLowerCase() + ")"));
    }
    else
    {
        cellDataElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_images") + " (" + imageLength + " " + stringBundle.getString("webdeveloper_files").toLowerCase() + ")"));
    }

    tableRowElement.appendChild(cellDataElement);

    totalCellDataElement = generatedDocument.createElement("td");

    totalCellDataElement.setAttribute("class", "size");
    tableRowElement.appendChild(totalCellDataElement);
    tableRowElement.setAttribute("class", "collapsed");
    tableElement.appendChild(tableRowElement);

    // Loop through the images
    for(i = 0; i < imageLength; i++)
    {
        cellDataElement = generatedDocument.createElement("td");
        image           = imageList[i];
        linkElement     = generatedDocument.createElement("a");
        src             = image.src;
        fileSize        = image.fileSize;
        tableRowElement = generatedDocument.createElement("tr");

        // If the file size is set
        if(fileSize)
        {
            calculatedFileSize += fileSize;
        }

        // If this is an even row
        if(i % 2 == 0)
        {
            tableRowElement.setAttribute("class", "hidden shaded");
        }
        else
        {
            tableRowElement.setAttribute("class", "hidden");
        }

        cellDataElement.setAttribute("class", "indent");
        tableRowElement.appendChild(cellDataElement);

        cellDataElement = generatedDocument.createElement("td");

        linkElement.setAttribute("href", src);
        linkElement.appendChild(generatedDocument.createTextNode(src));
        cellDataElement.appendChild(linkElement);
        tableRowElement.appendChild(cellDataElement);

        cellDataElement = generatedDocument.createElement("td");

        cellDataElement.setAttribute("class", "size");
        cellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(fileSize)));
        tableRowElement.appendChild(cellDataElement);
        tableElement.appendChild(tableRowElement);
    }

    totalCellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(calculatedFileSize)));

    totalFileSize             += calculatedFileSize;
    totalUncompressedFileSize += calculatedFileSize;

    calculatedFileSize = 0;
    cellDataElement    = generatedDocument.createElement("td");
    objectList         = webdeveloper_setScriptFileSizes(webdeveloper_tidyScripts(objectList)).sort(webdeveloper_sortScriptsByFileSize);
    objectLength       = objectList.length;
    tableRowElement    = generatedDocument.createElement("tr");

    cellDataElement.setAttribute("class", "pivot");
    tableRowElement.appendChild(cellDataElement);

    cellDataElement = generatedDocument.createElement("td");

    // If there is one object
    if(objectLength == 1)
    {
        cellDataElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_objects") + " (" + objectLength + " " + stringBundle.getString("webdeveloper_file").toLowerCase() + ")"));
    }
    else
    {
        cellDataElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_objects") + " (" + objectLength + " " + stringBundle.getString("webdeveloper_files").toLowerCase() + ")"));
    }

    tableRowElement.appendChild(cellDataElement);

    totalCellDataElement = generatedDocument.createElement("td");

    totalCellDataElement.setAttribute("class", "size");
    tableRowElement.appendChild(totalCellDataElement);
    tableRowElement.setAttribute("class", "collapsed");
    tableElement.appendChild(tableRowElement);

    // Loop through the objects
    for(i = 0; i < objectLength; i++)
    {
        cellDataElement = generatedDocument.createElement("td");
        linkElement     = generatedDocument.createElement("a");
        object          = objectList[i];
        src             = object.src;
        fileSize        = object.fileSize;
        tableRowElement = generatedDocument.createElement("tr");

        // If the file size is set
        if(fileSize)
        {
            calculatedFileSize += fileSize;
        }

        // If this is an even row
        if(i % 2 == 0)
        {
            tableRowElement.setAttribute("class", "hidden shaded");
        }
        else
        {
            tableRowElement.setAttribute("class", "hidden");
        }

        cellDataElement.setAttribute("class", "indent");
        tableRowElement.appendChild(cellDataElement);

        cellDataElement = generatedDocument.createElement("td");

        linkElement.setAttribute("href", src);
        linkElement.appendChild(generatedDocument.createTextNode(src));
        cellDataElement.appendChild(linkElement);
        tableRowElement.appendChild(cellDataElement);

        cellDataElement = generatedDocument.createElement("td");

        cellDataElement.setAttribute("class", "size");
        cellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(fileSize)));
        tableRowElement.appendChild(cellDataElement);
        tableElement.appendChild(tableRowElement);
    }

    totalCellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(calculatedFileSize)));

    totalFileSize             += calculatedFileSize;
    totalUncompressedFileSize += calculatedFileSize;

    calculatedFileSize             = 0;
    calculatedUncompressedFileSize = 0;
    cellDataElement                = generatedDocument.createElement("td");
    scriptList                     = webdeveloper_setScriptFileSizes(webdeveloper_tidyScripts(scriptList)).sort(webdeveloper_sortScriptsByFileSize);
    scriptLength                   = scriptList.length;
    tableRowElement                = generatedDocument.createElement("tr");

    cellDataElement.setAttribute("class", "pivot");
    tableRowElement.appendChild(cellDataElement);

    cellDataElement = generatedDocument.createElement("td");

    // If there is one script
    if(scriptLength == 1)
    {
        cellDataElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_scripts") + " (" + scriptLength + " " + stringBundle.getString("webdeveloper_file").toLowerCase() + ")"));
    }
    else
    {
        cellDataElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_scripts") + " (" + scriptLength + " " + stringBundle.getString("webdeveloper_files").toLowerCase() + ")"));
    }

    tableRowElement.appendChild(cellDataElement);

    totalCellDataElement = generatedDocument.createElement("td");

    totalCellDataElement.setAttribute("class", "size");
    tableRowElement.appendChild(totalCellDataElement);
    tableRowElement.setAttribute("class", "collapsed");
    tableElement.appendChild(tableRowElement);

    // Loop through the scripts
    for(i = 0; i < scriptLength; i++)
    {
        cellDataElement      = generatedDocument.createElement("td");
        linkElement          = generatedDocument.createElement("a");
        scriptElement        = scriptList[i];
        src                  = scriptElement.src;
        fileSize             = scriptElement.fileSize;
        tableRowElement      = generatedDocument.createElement("tr");
        uncompressedFileSize = scriptElement.uncompressedFileSize;

        // If the file size is set
        if(fileSize)
        {
            calculatedFileSize += fileSize;
        }

        // If the uncompressed file size is set and different from the file size
        if(uncompressedFileSize && uncompressedFileSize != fileSize)
        {
            calculatedUncompressedFileSize += uncompressedFileSize;
        }
        else
        {
            calculatedUncompressedFileSize += fileSize;
        }

        // If this is an even row
        if(i % 2 == 0)
        {
            tableRowElement.setAttribute("class", "hidden shaded");
        }
        else
        {
            tableRowElement.setAttribute("class", "hidden");
        }

        cellDataElement.setAttribute("class", "indent");
        tableRowElement.appendChild(cellDataElement);

        cellDataElement = generatedDocument.createElement("td");

        linkElement.setAttribute("href", src);
        linkElement.appendChild(generatedDocument.createTextNode(src));
        cellDataElement.appendChild(linkElement);
        tableRowElement.appendChild(cellDataElement);

        cellDataElement = generatedDocument.createElement("td");

        cellDataElement.setAttribute("class", "size");

        // If the uncompressed file size is set and different from the file size
        if(uncompressedFileSize && uncompressedFileSize != fileSize)
        {
            cellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(fileSize) + " (" + webdeveloper_formatFileSize(uncompressedFileSize) + " " + uncompressedLabel + ")"));
        }
        else
        {
            cellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(fileSize)));
        }

        tableRowElement.appendChild(cellDataElement);
        tableElement.appendChild(tableRowElement);
    }

    // If the calculated file size and calculated uncompressed file size are set and different
    if(calculatedFileSize && calculatedUncompressedFileSize && calculatedFileSize != calculatedUncompressedFileSize)
    {
        totalCellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(calculatedFileSize) + " (" + webdeveloper_formatFileSize(calculatedUncompressedFileSize) + " " + uncompressedLabel + ")"));
    }
    else
    {
        totalCellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(calculatedFileSize)));
    }

    totalFileSize             += calculatedFileSize;
    totalUncompressedFileSize += calculatedUncompressedFileSize;

    calculatedFileSize             = 0;
    calculatedUncompressedFileSize = 0;
    cellDataElement                = generatedDocument.createElement("td");
    styleSheetList                 = webdeveloper_setStyleSheetFileSizes(webdeveloper_tidyStyleSheets(styleSheetList)).sort(webdeveloper_sortStyleSheetsByFileSize);
    styleSheetLength               = styleSheetList.length;
    tableRowElement                = generatedDocument.createElement("tr");

    cellDataElement.setAttribute("class", "pivot");
    tableRowElement.appendChild(cellDataElement);

    cellDataElement = generatedDocument.createElement("td");

    // If there is one style sheet
    if(styleSheetLength == 1)
    {
        cellDataElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_styleSheets") + " (" + styleSheetLength + " " + stringBundle.getString("webdeveloper_file").toLowerCase() + ")"));
    }
    else
    {
        cellDataElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_styleSheets") + " (" + styleSheetLength + " " + stringBundle.getString("webdeveloper_files").toLowerCase() + ")"));
    }

    tableRowElement.appendChild(cellDataElement);

    totalCellDataElement = generatedDocument.createElement("td");

    totalCellDataElement.setAttribute("class", "size");
    tableRowElement.appendChild(totalCellDataElement);
    tableRowElement.setAttribute("class", "collapsed");
    tableElement.appendChild(tableRowElement);

    // Loop through the style sheets
    for(i = 0; i < styleSheetLength; i++)
    {
        cellDataElement      = generatedDocument.createElement("td");
        linkElement          = generatedDocument.createElement("a");
        styleSheet           = styleSheetList[i];
        src                  = styleSheet.href;
        fileSize             = styleSheet.fileSize;
        tableRowElement      = generatedDocument.createElement("tr");
        uncompressedFileSize = styleSheet.uncompressedFileSize;

        // If the file size is set
        if(fileSize)
        {
            calculatedFileSize += fileSize;
        }

        // If the uncompressed file size is set and different from the file size
        if(uncompressedFileSize && uncompressedFileSize != fileSize)
        {
            calculatedUncompressedFileSize += uncompressedFileSize;
        }
        else
        {
            calculatedUncompressedFileSize += fileSize;
        }

        // If this is an even row
        if(i % 2 == 0)
        {
            tableRowElement.setAttribute("class", "hidden shaded");
        }
        else
        {
            tableRowElement.setAttribute("class", "hidden");
        }

        cellDataElement.setAttribute("class", "indent");
        tableRowElement.appendChild(cellDataElement);

        cellDataElement = generatedDocument.createElement("td");

        linkElement.setAttribute("href", src);
        linkElement.appendChild(generatedDocument.createTextNode(src));
        cellDataElement.appendChild(linkElement);
        tableRowElement.appendChild(cellDataElement);

        cellDataElement = generatedDocument.createElement("td");

        cellDataElement.setAttribute("class", "size");

        // If the uncompressed file size is set and different from the file size
        if(uncompressedFileSize && uncompressedFileSize != fileSize)
        {
            cellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(fileSize) + " (" + webdeveloper_formatFileSize(uncompressedFileSize) + " " + uncompressedLabel + ")"));
        }
        else
        {
            cellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(fileSize)));
        }

        tableRowElement.appendChild(cellDataElement);
        tableElement.appendChild(tableRowElement);
    }

    // If the calculated file size and calculated uncompressed file size are set and different
    if(calculatedFileSize && calculatedUncompressedFileSize && calculatedFileSize != calculatedUncompressedFileSize)
    {
        totalCellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(calculatedFileSize) + " (" + webdeveloper_formatFileSize(calculatedUncompressedFileSize) + " " + uncompressedLabel + ")"));
    }
    else
    {
        totalCellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(calculatedFileSize)));
    }

    totalFileSize             += calculatedFileSize;
    totalUncompressedFileSize += calculatedUncompressedFileSize;

    cellDataElement = generatedDocument.createElement("td");
    tableRowElement = generatedDocument.createElement("tr");

    cellDataElement.setAttribute("class", "total-indent");
    tableRowElement.setAttribute("class", "total");
    tableRowElement.appendChild(cellDataElement);

    cellDataElement = generatedDocument.createElement("td");

    cellDataElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_total")));
    tableRowElement.appendChild(cellDataElement);

    cellDataElement = generatedDocument.createElement("td");

    cellDataElement.setAttribute("class", "size");

    // If the total file size and total uncompressed file size are set and different
    if(totalFileSize && totalUncompressedFileSize && totalFileSize != totalUncompressedFileSize)
    {
        cellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(totalFileSize) + " (" + webdeveloper_formatFileSize(totalUncompressedFileSize) + " " + uncompressedLabel + ")"));
    }
    else
    {
        cellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(totalFileSize)));
    }

    tableRowElement.appendChild(cellDataElement);
    tableElement.appendChild(tableRowElement);
    bodyElement.appendChild(tableElement);

    scriptElement = generatedDocument.createElement("script");

    scriptElement.setAttribute("defer", "defer");
    scriptElement.setAttribute("src", "chrome://webdeveloper/content/common/xpath.js");
    scriptElement.setAttribute("type", "text/javascript");
    headElement.appendChild(scriptElement);

    scriptElement = generatedDocument.createElement("script");

    scriptElement.setAttribute("defer", "defer");
    scriptElement.setAttribute("src", "chrome://webdeveloper/content/generated/table_pivot.js");
    scriptElement.setAttribute("type", "text/javascript");
    headElement.appendChild(scriptElement);

    // If the open tabs in background preference is set to true
    if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true))
    {
        getBrowser().selectedTab = oldTab;
    }
}
