/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.core;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLMetadataObjectNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseMetadataObjectNode;

public class BaseMetadataInteger
extends BaseMetadataObjectNode {
    protected static final int FIELD_VALUE = 3;
    protected static final int LAST_INTEGER_INDEX = 3;
    protected static VRMLFieldDeclaration[] fieldDecl;
    protected static HashMap fieldMap;
    private static int[] nodeFields;
    protected int[] vfValue;
    protected int numValue;

    public BaseMetadataInteger() {
        super("MetadataInteger");
        this.hasChanged = new boolean[4];
        this.vfValue = FieldConstants.EMPTY_MFINT32;
    }

    public BaseMetadataInteger(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLMetadataObjectNodeType)((Object)vRMLNodeType));
        try {
            int n = vRMLNodeType.getFieldIndex("value");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfValue = new int[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfValue, 0, vRMLFieldData.numElements);
            }
            this.numValue = vRMLFieldData.numElements;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.intArrayValue = this.vfValue;
                vRMLFieldData.dataType = (short)9;
                vRMLFieldData.numElements = this.numValue;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfValue, this.numValue);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                if (this.vfValue.length < n2) {
                    this.vfValue = new int[n2];
                }
                this.numValue = n2;
                System.arraycopy(nArray, 0, this.vfValue, 0, n2);
                break;
            }
            default: {
                super.setValue(n, nArray, n2);
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[4];
        fieldMap = new HashMap(9);
        BaseMetadataInteger.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseMetadataInteger.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFString", "name");
        BaseMetadataInteger.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFString", "reference");
        BaseMetadataInteger.fieldDecl[3] = new VRMLFieldDeclaration(3, "MFInt32", "value");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("name", n);
        fieldMap.put("set_name", n);
        fieldMap.put("name_changed", n);
        n = new Integer(2);
        fieldMap.put("reference", n);
        fieldMap.put("set_reference", n);
        fieldMap.put("reference_changed", n);
        n = new Integer(3);
        fieldMap.put("value", n);
        fieldMap.put("set_value", n);
        fieldMap.put("value_changed", n);
    }
}

