/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.6.1
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <vdkb/colorcombo.h>
void 
VDKColorComboBox::OnChange(GtkWidget *wid, 
			   gint i, gchar *color_name, gpointer gp)
{
  g_return_if_fail(wid != NULL);
  g_return_if_fail(gp != NULL);
  /* a little trick here:
     we must stop signal since callback args do not match
     with those defined for dynamic tables.
     User should connect with this signal using
     SignalConnect(<object>,"changed",false);
     so no real connection will be made.
     Or using static tables.
     
   */
  gtk_signal_emit_stop_by_name(GTK_OBJECT(wid),"changed");
  VDKColorComboBox* obj = reinterpret_cast<VDKColorComboBox*>(gp);
  obj->SelectedColor(VDKString(color_name));
  obj->Canvas->NormalBackground = VDKRgb(color_name); 
  obj->Canvas->Clear(); 
  obj->SignalEmitParent(changed_signal);
  obj->SignalEmit("changed");
}
/*
 */
int 
VDKColorComboBox::OnExpose(GtkWidget *wid, 
			    GdkEventExpose* ev,
			    gpointer gp)
{
  g_return_val_if_fail(wid != NULL,FALSE);
  g_return_val_if_fail(gp != NULL,FALSE);
  VDKColorComboBox* obj = reinterpret_cast<VDKColorComboBox*>(gp);
  obj->Canvas->Redraw(); 
  return TRUE;
}
/*
 */
void 
VDKColorComboBox::OnClicked(GtkWidget *wid, gpointer gp)
{
  g_return_if_fail(wid != NULL);
  g_return_if_fail(gp != NULL);
  VDKColorComboBox* obj = reinterpret_cast<VDKColorComboBox*>(gp);
  /*
  VDKString color = obj->SelectedColor;
  if(! color.isNull())
    {
      obj->Canvas->NormalBackground = VDKRgb(color); 
      obj->Canvas->Clear(); 
    }
  */
  obj->SignalEmitParent(clicked_signal);
  obj->SignalEmit("clicked");
}
/*
 */
VDKColorComboBox::VDKColorComboBox(VDKForm* owner,char* label):
  VDKCustomComboBox(owner),
  SelectedColor("SelectedColor",this,"")
{
  widget = sigwid = gtk_color_combo_new();
  gtk_widget_set_usize(GTK_WIDGET(GTK_COMBO_BOX(widget)->button),30,25);
  VDKBox* buttonbox = new VDKBox(owner,h_box);
  Canvas = new VDKCanvas(owner,20,20);
  buttonbox->Add(Canvas);
  if(label)
    buttonbox->Add(Label = new VDKLabel(owner,label,GTK_JUSTIFY_CENTER));
  else
    Label = NULL;
  gtk_container_add(GTK_CONTAINER(GTK_COMBO_BOX(widget)->button),
		   GTK_WIDGET(buttonbox->Widget()));
  AddItem(buttonbox);
  buttonbox->Visible = true;
  gtk_signal_connect(GTK_OBJECT(widget),
		     "changed", 
		     GTK_SIGNAL_FUNC(VDKColorComboBox::OnChange), this);
  gtk_signal_connect(GTK_OBJECT(GTK_COMBO_BOX(widget)->button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(VDKColorComboBox::OnClicked), this);
  gtk_signal_connect(GTK_OBJECT(Canvas->WrappedWidget()),
		     "expose_event", 
		     GTK_SIGNAL_FUNC(VDKColorComboBox::OnExpose), this);
}






