/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_scrolled_h
#define _vdkb_scrolled_h

#include <vdkb/vdkb_evcontain.h>
#include <vdkb/vdkb_evbox.h>
#include <vdk/menu.h>

class VDKBGuiForm;
class VDKBParser;
class VDKBObjectInspector;

class VDKBScrolled: public VDKBEventContainer
{
  VDKMenuItem *delBox;
  VDKMenuItem *addwidget,*delwidget,*setsize;
  // property controls used by object inspector
  VDKEntry *label;
  void Init();
 public:
  static int Counter;
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, char* buffer,
			   VDKBParser& parser);


  VDKBScrolled(char* name, VDKForm* owner);
  VDKBScrolled(char* name, VDKBEventContainer* outer);
  virtual ~VDKBScrolled() {}

  void Add(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs);
  
  void AddBox();
  void AddWidget(VDKObject* w, int justify = l_justify,
		 int expand = TRUE, int fill = TRUE , 
		 int padding = 0, bool forceArgs = false);
  bool AddNewWidget(VDKObject* sender);
  void PopMenu() { popmenu->Popup(); }
  bool DelBox(VDKObject* sender);

  virtual int Type() { return vdkbscrolled_class; }
  virtual int isA() { return vdkbscrolled_class; }
  virtual char* VDKName() { return "VDKScrolled"; }


  void WriteOnFrm(FILE* fp, VDKBObject* parentobj);
  VDKObjectContainer*  ExtraWidget(VDKBObjectInspector* isp);
  bool SetBoxSize(VDKObject* sender);
  //
  DECLARE_EVENT_LIST(VDKBScrolled);
  DECLARE_SIGNAL_LIST(VDKBScrolled);
};

#endif

