/*
  canvas Form
  implementation file:canvas.cc
*/
#include <canvas.h>
// Canvas FORM  CLASS
/*
  events map 
*/ 
DEFINE_EVENT_MAP(CanvasForm,VDKForm) 
    ON_EVENT(canvas,motion_notify_event,OnMotion), 
    ON_EVENT(canvas,configure_event,OnConfigure),
    ON_EVENT(canvas,expose_event,OnExpose),
    ON_EVENT(canvas,drag_start_event,OnDragStart),
    ON_EVENT(canvas,dragging_event,OnDragging),
    ON_EVENT(canvas,drag_stop_event,OnDragStop)
END_EVENT_MAP

static VDKRawPixmap* nicegirl = NULL;

static char buff[128];
/*
form constructor
*/
CanvasForm::CanvasForm(VDKForm* owner, char* title):
	VDKForm(owner,title)
{
}

/*
form destructor
*/
CanvasForm::~CanvasForm()
{
}

/*
form setup
*/
void
CanvasForm::Setup(void)
{
  GUISetup(); // vdkb gui setup
  // put your code below here
  canvas->NormalBackground = clIvory;
  canvas->Foreground = clNavyBlue;
  canvas->Captured = false;
  canvas->EnableClear = false;
  nicegirl=0;
  lastdraw = VDKPoint(0,0);
}
/* 
 */ 
bool 
CanvasForm::OnMotion(VDKObject*, GdkEvent* ev)
{
  GdkEventMotion* event = reinterpret_cast<GdkEventMotion*>(ev);
  sprintf(buff,"Coords:%.0f,%.0f",event->x,event->y);
  label->Caption = buff;
  return true;
}

/*
 */
bool 
CanvasForm::OnConfigure(VDKObject*, GdkEvent*)
{
  canvas->Clear();
  if (!nicegirl)
    {
      canvas->DrawString(80,100,"Hello world !");
      canvas->Cursor = curCrossHair;
    }
  else
    canvas->DrawPixmap(lastdraw.X(),lastdraw.Y(),nicegirl);
  canvas->Redraw();
  return true;
} 
 
/* 
 */
bool 
CanvasForm::OnDragStart(VDKObject*, GdkEvent* ev) 
{
  GdkEventButton* event = reinterpret_cast<GdkEventButton*>(ev);
  canvas->Cursor = curPencil;
  lastdraw = VDKPoint(int(event->x),int(event->y));
  return true;
}

/*   
 */ 
bool 
CanvasForm::OnDragging(VDKObject*, GdkEvent* ev) 
{
  GdkEventMotion* event = reinterpret_cast<GdkEventMotion*>(ev);
  if(!nicegirl)
    {
      GdkRectangle brush;
      brush.x = int(event->x-2);
      brush.y = int(event->y-2);
      brush.width = 4;
      brush.height = 4;
      canvas->DrawRect(true,brush.x,brush.y,brush.width,brush.height);
    }
  else
    {
      canvas->Clear();
      canvas->DrawPixmap(event->x,event->y,nicegirl);
      lastdraw = VDKPoint(event->x,event->y);
    }
  canvas->Redraw();
  return true;
}
  
/*
 */  
bool
CanvasForm::OnDragStop(VDKObject*, GdkEvent* ) 
{
  canvas->Cursor = curCrossHair;  
  return true;
}

/*  
 */
bool
CanvasForm::OnExpose(VDKObject*, GdkEvent* ) 
{ 
  return true;
}

bool 
CanvasForm::DrawNiceLinux(VDKObject*) 
{ 
  canvas->Clear();
  if(!nicegirl)
    {
      nicegirl = new VDKRawPixmap(canvas,"linuxGirl.xpm");
      lastdraw = VDKPoint(0,0);
    }
  canvas->DrawPixmap(lastdraw.X(),lastdraw.Y(),nicegirl);
  canvas->Redraw();
  return true;
} 
  
bool 
CanvasForm::Clear(VDKObject*)  
{
  if (nicegirl)
    nicegirl = 0;
  OnConfigure(0,0);
  return true;
}