<!--
  Stylesheet to convert Dilbert daily strips to RSS.

  Copyright (C) 2013-2014  Antonio Ospite <ao2@ao2.it>

  This file is part of tweeper.

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->

<!--
  Since June 18, 2013 dilbert.com strips are not accessible anymore
  directly from the RSS feed, this message is displayed instead:

    Dilbert readers - Please visit Dilbert.com to read this feature. Due
    to changes with our feeds, we are now making this RSS feed a link to
    Dilbert.com.

  How unhandy is that, was it because of a management decision?
  Maybe a parody dilbert strip is needed about this issue...
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:php="http://php.net/xsl"
    xsl:extension-element-prefixes="php">

    <xsl:output method="xml" indent="yes"/>

    <xsl:variable name="BaseURL" select="concat('http://', //meta[@property='og:site_name']/@content)"/>

    <xsl:template match="//a[@id='strip_zoom']">
        <xsl:variable name="picture-id" select="substring-after(./@href, '#')"/>
        <xsl:variable name="picture-element" select="//div[@id=$picture-id]/img"/>
        <xsl:variable name="picture-print-url" select="php:functionString('str_replace', 'zoom', 'print', $picture-element/@src)"/>
        <item>
            <title>
                <xsl:value-of select="$picture-element/@title"/>
            </title>
            <link>
                <xsl:value-of select="concat($BaseURL, $picture-element/@src)"/>
            </link>
            <pubDate>
                <xsl:value-of select="php:functionString('Tweeper::str_to_gmdate', substring-after($picture-id, 'strip_enlarged_'))"/>
            </pubDate>
            <description>
                <xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
                <img src="{$picture-print-url}" />
                <xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
            </description>
        </item>
    </xsl:template>

    <xsl:template match="/">

        <rss version="2.0">
            <xsl:attribute name="xml:base"><xsl:value-of select="$BaseURL" /></xsl:attribute>
            <channel>
                <generator>Tweeper</generator>
                <title>
                    <xsl:value-of select="//meta[@property='og:title']/@content"/>
                </title>
                <link>
                    <xsl:value-of select="$BaseURL"/>
                </link>
                <description>
                    <xsl:value-of select="//meta[@property='og:description']/@content"/>
                </description>
                <image>
                    <url>
                        <xsl:value-of select="//meta[@property='og:image']/@content"/>
                    </url>
                </image>
                <xsl:apply-templates select="//a[@id='strip_zoom']"/>
            </channel>
        </rss>
    </xsl:template>
</xsl:stylesheet>
