#include "camenulabel.h"
#include "camenu.h"
#include "caresources.h"

/** Constructor.
*/
CAMenuLabel::CAMenuLabel( CAMenu* menu, int pos, const char* label )
        : CAMenuItem( menu, pos, label ) {
    font=0;
}


/** Destructor.
*/
CAMenuLabel::~CAMenuLabel() {}



/** Displays the menu label.
*/
void
CAMenuLabel::display( bool highlight ) {
    static float frame = 0.0;
    top = menu->getTop() + pos*menu->getItemHeight() + menu->getHeaderHeight();

    if( highlight ) {
        font = CA_RES->font_normal_22_white;
        CA_RES->menu_cursorani->put_screen( menu->getLeft()-40, top+5, (int)frame );
        CA_RES->advanceAnimation( &frame, CA_RES->menu_cursorani, 10.0 );
    } else {
        font = CA_RES->font_normal_22_gray;
    }

    font->print_left( menu->getLeft() + CA_MENUSPACE/2,
                      top + CA_MENUSPACE/2,
                      label );
}



/** Handles keys on this label.
*/
void
CAMenuLabel::handleKey( const CL_Key &key ) {
    // Do nothing
}


// EOF
