// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef MAT_INC
#define MAT_INC

#include "Object.h"
#include "Vec.h"

namespace Torch {

/** Matrix object.

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class Mat : public Object
{
  public:

    /** #false# if #ptr# is not allocated by Mat.
        (With the first constructor)
    */
    bool ptr_is_allocated;
    
    /// Size of the matrix
    int m, n;
    
    /// Data of the matrix
    real **ptr;
    
    /** NULL if not allocated by Mat.
        (when you're using the first constructor of Mat, or for
        the matrix returned by subMat)
    */
    real *base;
    
    /** Create a matrix from values in #ptr_#.
        (No memory copy).
    */
    Mat(real ** ptr_, int n_rows, int n_cols);
    
    /// Create a new matrix
    Mat(int n_rows, int n_cols);
    
    /// Copy the matrix #mat#
    void copy(Mat * mat);
    
    /// Zero the matrix
    void zero();
    
    /// Compute the norm1
    real norm1();
    
    /// Compute the Frobenius norm
    real normFrobenius();
    
    /// Compute the norm inf
    real normInf();
    
    /** Return the row #row# of the matrix.
        If #vec# is NULL, return a new vector.
        Else copy the row in #vec#.
    */
    Vec *getRow(int row, Vec * vec = NULL);
    
    /** Return the column #col# of the matrix.
        If #vec# is NULL, return a new vector.
        Else copy the column in #vec#.
    */
    Vec *getCol(int col, Vec * vec = NULL);
    
    /// Set the row #row# to values in #vec#
    void setRow(int row, Vec * vec);
    
    /// Set the column #col# to values in #vec#
    void setCol(int row, Vec * vec);
    
    /** Return a sub-matrix.
        Note that the memory is shared with the original
        matrix, so *be carefull*.
    */
    Mat *subMat(int row1, int col1, int row2, int col2);

   ~Mat();
};


}

#endif
