// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef PARZEN_MACHINE_INC
#define PARZEN_MACHINE_INC

#include "Machine.h"
#include "DataSet.h"

namespace Torch {

/** This machine implements the Parzen Window estimator.
    Given a dataset (in the constructor), the #forward# method returns
    for a given input the average of the outputs of the training set
    weighted by a Gaussian kernel distance:

    $ y(x) = \frac{\sum_i t_i \exp(- \frac{||x - x_i||^2}{2 var})}{\sum_i \exp(- \frac{||x - x_i||^2}{2 var})}$

    The only parameter #var# is given in the constructor.

    @author Samy Bengio (bengio@idiap.ch)
*/
class ParzenMachine : public Machine
{
  public:

    /// the variance used
    real var;

    /// The dataset that contains the training set
    DataSet* data;

    /// the indices of the training examples
    int *real_examples;
    int n_real_examples;

    /// keep the denominator
    real denominator;

    ///
    ParzenMachine(DataSet* data_,real var_);

    virtual void forward(List *inputs);
    virtual void reset();

    /// change the value of var
    virtual void setVar(real var_);

    virtual ~ParzenMachine();
};


}

#endif
