# $Id: iface.tcl

namespace eval ifaceck {

    custom::defvar options(raise_new_tab) 1 \
	[::msgcat::mc "Raise new tab."] \
	-group IFace -type boolean

    proc isource {file} {
	set dir [file dirname [info script]]
	source [file join $dir $file]
    }

    isource ilogin.tcl
    isource iroster.tcl
}

option add *errorForeground red widgetDefault

set usetabbar 1

proc ifaceck::quick_help_window {} {

    help_window [::msgcat::mc "Quick Help"] \
"\n[::msgcat::mc {Main window:}]
    Ctrl-L\t\t\t[::msgcat::mc {Log in}]
    Ctrl-J\t\t\t[::msgcat::mc {Log out}]
\n[::msgcat::mc Tabs:]
    Ctrl-F4\t\t\t[::msgcat::mc {Close tab}]
    Ctrl-PgUp/Down\t\t[::msgcat::mc {Previous/Next tab}]
    Ctrl-Alt-PgUp/Down\t[::msgcat::mc {Move tab left/right}]
    Alt-\[1-9,0\]\t\t[::msgcat::mc {Switch to tab number 1-9,10}]
    Ctrl-R\t\t\t[::msgcat::mc {Hide/Show roster}]
\n[::msgcat::mc Chats:]
    TAB\t\t\t[::msgcat::mc {Complete nickname}]
    Ctrl-Up/Down\t\t[::msgcat::mc {Previous/Next history message}]
    Alt-E\t\t\t[::msgcat::mc {Show emoticons}]
    Ctrl-Z\t\t\t[::msgcat::mc {Undo}]
    Ctrl-Shift-Z\t\t[::msgcat::mc {Redo}]
    Alt-PgUp/Down\t\t[::msgcat::mc {Scroll chat window up/down}]
    [::msgcat::mc {Right mouse  }]\t[::msgcat::mc {Correct word}]
"
}

proc ifaceck::about_window {} {
    global version

    help_window [::msgcat::mc "About"] "
Tkabber $version

Copyright \u00a9 2002-2004 [::msgcat::mc {Alexey Shchepin}]
\n[::msgcat::mc Authors:]
    [::msgcat::mc {Alexey Shchepin}]
    [::msgcat::mc {Marshall T. Rose}]
    [::msgcat::mc {Sergei Golovan}]
    [::msgcat::mc {Michail Litvak}]

http://tkabber.jabberstudio.org/"
}

proc ifaceck::help_window {title message} {
    ck_dialog .m $title $message [::msgcat::mc "OK"]
}

proc ifaceck::create_menu {path menu} {

    set menunum 0
    foreach {name tags menuid tearoff entries} $menu {
	if {[cequal $menuid {}]} {
	    set id "menu$menunum"
	} else {
	    set id $menuid
	}
	incr menunum
	regsub -all {&} $name {} label
	set m [menubutton $path.$id \
	    -text $label -menu $path.$id.menu]
	pack $m -side left -padx [expr {$menunum % 2}]
	menu $path.$id.menu
	create_menu_entries $path $path.$id.menu $entries
    }
}

proc ifaceck::create_menu_entries {path menu entries} {

    set count 0
    foreach ent $entries {
	set opt {}
	set type [lindex $ent 0]
	switch -- $type {
	    separator {
		$menu add separator
	    }
	    cascad {
		set opt [list -label [lindex $ent 1]]
		set menuid [lindex $ent 3]
		set submenu $menu.menu$count
		eval $menu add cascad $opt -menu $submenu
		menu $submenu
		if { [string length $menuid] } {
		    # menu has identifier
		    #set _widget($path,menuid,$menuid) $submenu
		}
		create_menu_entries $path $submenu [lindex $ent 5]
	    }
	    command -
	    radiobutton -
	    checkbutton {
		set opt [list -label [lindex $ent 1]]
		set accel [lindex $ent 4]
		if {[llength $accel]} {
		    lappend opt -accelerator $accel
		    #bind $_widget($path,top) [lindex $accel 1] "$menu invoke $count"
		}
		set useropt [lrange $ent 5 end]
		eval $menu add $type $opt $useropt
	    }
	    default {
		return -code error "invalid menu type \"$type\""
	    }
	}
	incr count
    }
}

proc ifaceck::set_indicator_state {path state {help ""}} {
    if {[cequal $state on]} {
	set attr {bold}
    } else {
	set attr {}
    }
    $path configure -attributes $attr
}


proc ifaceck::create_main_window {} {
    global use_tls
    global descmenu
    global user_status_list
    variable ssl_ind

    bind . <Control-c> {
	jlib::disconnect
	quit
    }

    menubutton .fake
    set bg [option get .fake background Menubutton]
    destroy .fake

    grid rowconfigure . 1 -weight 1
    grid columnconfigure . 1 -weight 1

    frame .top -background $bg
    grid .top -row 0 -column 0 -columnspan 2 -sticky we

    #create_menu .top $descmenu
    #unset descmenu

    frame .bot -class Status
    label .bot.status -textvariable status
    pack .bot.status -side left -padx 1
    if {$use_tls} {
	set ssl_ind [label .bot.sslstatus -text "SSL" -attributes {}]
	# [::msgcat::mc "Disconnected"]
	pack $ssl_ind -side right
    }
    grid .bot -row 3 -column 0 -columnspan 2 -sticky we
    bind . <Destroy> {
	jlib::disconnect
	quit
    }

    set ww 0
    foreach {status str} $user_status_list {
	if {[string length $str] > $ww} {
	    set ww [string length $str]
	}
    }


    if {[winfo exists [set m .presence.button.menu]]} {
	destroy $m
    }
    frame .presence
    menubutton .presence.button -menu $m \
	-textvariable userstatusdesc -width [expr {$ww + 2}]
    unset str ww
    bind [entry .presence.status -textvariable textstatus] \
	<Return> {set userstatus $userstatus}
    pack .presence.button -side left
    pack .presence.status -side left -fill x -expand yes
    grid .presence -row 2 -column 0 -columnspan 2 -sticky we

    menu $m
    foreach {status str} $user_status_list {
        if {![cequal $status unavailable]} {
            $m add command -label $str \
            -command [list set userstatus $status]
        }
    }
    
    set rosterwidth [option get . mainRosterWidth [winfo class .]]
    if {$rosterwidth == ""} {
	set rosterwidth 12
    }

    roster::create .roster -width $rosterwidth -height 20 \
	-popup roster::popup_menu \
	-grouppopup roster::group_popup_menu

    grid .roster -row 1 -column 0 -sticky nwse
    set roster_is_shown 1

    bind . <Control-r> {collapse_roster}

    NoteBook .nb
    grid .nb -row 1 -column 1 -sticky nwse

    if {0} {
	set pw [PanedWin [$mf getframe].pw -side bottom -pad 2 -width 8]
	pack $pw -fill both -expand yes
	set rw [$pw add -minsize 0 -weight 0]
	set nw [$pw add -minsize 32 -weight 1]

	roster::create $w.roster -width $rosterwidth -height 20 \
	    -popup roster::popup_menu \
	    -grouppopup roster::group_popup_menu
	pack $w.roster -expand yes -fill both -side left -in $rw

	NoteBook .nb -width 400
	pack .nb -side right -in $nw -fill both -expand yes
	[winfo parent $rw] configure -width $rosterwidth

	bind . <Control-Prior> {tab_move .nb -1}
	bind . <Control-Next> {tab_move .nb 1}
	bind . <Control-Meta-Prior> {current_tab_move .nb -1}
	bind . <Control-Alt-Prior>  {current_tab_move .nb -1}
	bind . <Control-Meta-Next>  {current_tab_move .nb  1}
	bind . <Control-Alt-Next>   {current_tab_move .nb  1}
	bind . <Control-Key-F4> {
	    if {[.nb raise] != ""} {
		eval destroy [pack slaves [.nb getframe [.nb raise]]]
		.nb delete [.nb raise] 1
		tab_move .nb 0
	    }
	}

	for {set i 1} {$i < 10} {incr i} {
	    bind . <Meta-Key-$i> [list tab_raise_by_number .nb $i]
	    bind . <Alt-Key-$i> [list tab_raise_by_number .nb $i]
	}
	unset i
	bind . <Meta-Key-0> [list tab_raise_by_number .nb 10]
	bind . <Alt-Key-0> [list tab_raise_by_number .nb 10]

	set m [menu .tabsmenu -tearoff 0]
	$m add command -label [::msgcat::mc "Close"] -accelerator Ctrl-F4 \
	    -command {
		if {[.nb raise] != ""} {
		    eval destroy [pack slaves [.nb getframe $curmenutab]]
		    .nb delete $curmenutab 1
		    tab_move .nb 0
		}
	    }
	$m add command -label [::msgcat::mc "Close other tabs"] \
	    -command {
		foreach tab [.nb pages] {
		    if {$tab != $curmenutab} {
			eval destroy [pack slaves [.nb getframe $tab]]
			.nb delete $tab 1
		    }
		}
		tab_move .nb 0
	    }
	$m add command -label [::msgcat::mc "Close all tabs"] \
	    -command {
		foreach tab [.nb pages] {
		    eval destroy [pack slaves [.nb getframe $tab]]
		    .nb delete $tab 1
		}
	    }

	.nb bindtabs <3> {tab_menu %X %Y}

	set geometry [option get . geometry [winfo class .]]
	if {$geometry == ""} {
	    set geometry 788x550+0+0
	}
	unset pw m
	wm geometry . $geometry
    }

    if {0} {
	bind . <FocusIn> [list ::get_focus .]
	bind . <FocusOut> [list ::lose_focus .]
    }
}

hook::add finload_hook [namespace current]::ifaceck::create_main_window 1


proc ifaceck::nbpage {path} {
    return [crange [win_id tab $path] 1 end]
}

proc add_win {args} {
    eval ifaceck::add_win $args
}

proc ifaceck::add_win {path args} {
    global usetabbar
    variable options

    set title ""
    set tabtitle ""
    set class ""
    set raisecmd ""
    set type ""

    foreach {attr val} $args {
	switch -- $attr {
	    -title    {set title    $val}
	    -tabtitle {set tabtitle $val}
	    -class    {set class    $val}
	    -raisecmd {set raisecmd $val}
	    -type     {set type     $val}
	    default   {error "Unknown option $attr"}
	}
    }

    if {$usetabbar} {
	set page [nbpage $path]
	set f [.nb insert end $page -text $tabtitle -raisecmd $raisecmd]
	frame $path -class $class
	pack $path -expand yes -fill both -in $f
	#tkwait visibility $path
	set ::tabcolors($page) ""
	if {$options(raise_new_tab) || [llength [.nb pages]] == 1} {
	    after idle [list catch [list .nb raise $page]]
	}
    } else {
	toplevel $path -class $class -relief flat -bd 2m
	wm title $path $title
	wm iconname $path $title
	set geometry [option get $path ${type}geometry $class]
	if {$geometry != ""} {
	    wm geometry $path $geometry
	}
	bind $path <FocusIn>  [list [namespace current]::get_focus $path]
	bind $path <FocusOut> [list [namespace current]::loose_focus $path]
    }
}

###############################################################################

proc ifaceck::collapse_roster {} {
    global roster_is_shown

    if {$roster_is_shown} {
	grid forget .roster
    } else {
	grid .roster -row 1 -column 0 -sticky nwse
    }
    set roster_is_shown [expr {!$roster_is_shown}]
}

