var prefs = Components.classes["@mozilla.org/preferences-service;1"]
 	                    .getService(Components.interfaces.nsIPrefBranch);

// reload the timeline
function refresh() {
    var browser = document.getElementById("timeline");
    if (browser) {
        browser.reload();
    }
}

// reload the timeline every 30 minutes to refresh the events
window.setInterval("refresh",1800000);

// Make the timeline option in the view menu show and hide the timeline.
function setTimelineCheckBox() {
    goToggleToolbar('timeline_vbox', 'show_timeline')
    refresh();
}

//This function takes the mouse wheel event and alters the zoom of the timeline.
// delta is + or - depending on which way the mouse wheel is rolled
function handle(delta) {        	
		var size = prefs.getIntPref("extensions.timeline.hour");
        if (delta < 0) {
			size = size*2;
        } else{
        	size = size/2;
		}
		if (size < 8) size = 8;
		if (size > 256) size = 256;
		prefs.setIntPref("extensions.timeline.hour", size);
		refresh();
}

//Event handler for mouse wheel event.
function wheel(event){
        //If event.detail is non-zero, alter extensions.timeline.hour
        if (event.detail)
			handle(event.detail);
		//also suppress the default mouse wheel action (scrolling usually)
        if (event.preventDefault)
			event.preventDefault();
		event.returnValue = false;
}

//These functions are called when the mouse enters or leaves the Timeline area
function initScroll() {
	window.addEventListener('DOMMouseScroll', wheel, false);
	return;
}

function removeScroll() {
	window.removeEventListener('DOMMouseScroll', wheel, false);
	return;
}

