/* Hey EMACS -*- linux-c -*-
 *
 * tiglusb - low level driver for SilverLink cable
 *
 * Copyright (C) 2000-2002, Romain Lievin <roms@tilp.info>
 * under the terms of the GNU General Public License.
 *
 * Redistribution of this file is permitted under the terms of the GNU
 * Public License (GPL)
 */

#ifndef _TIGLUSB_H
#define _TIGLUSB_H

#include <linux/version.h>

#define VERSION(ver,rel,seq) (((ver)<<16) | ((rel)<<8) | (seq))

/*
 * Max. number of devices supported
 */
#define MAXTIGL		16

/*
 * Max. packetsize for IN and OUT pipes
 */
#define BULK_RCV_MAX	32
#define BULK_SND_MAX	32

/*
 * The driver context...
 */

typedef enum { _stopped=0, _started } driver_state_t;

typedef struct
{
	struct usb_device	*dev;		/* USB device handle */
	struct semaphore	mutex;		/* locks this struct */

	wait_queue_head_t	wait;		/* for timed waits */
	wait_queue_head_t	remove_ok;

	int		minor;			/* which minor dev #? */
#if LINUX_VERSION_CODE < VERSION(2,6,0)
	devfs_handle_t	devfs;			/* devfs device */
#endif
	driver_state_t	state;			/* started/stopped */
	int		opened;			/* tru if open */
	int	remove_pending;
} tiglusb_t, *ptiglusb_t;

#endif
