/* -*- mode: c; c-file-style: "gnu" -*-
 * misc.h -- Miscellaneous routine prototypes
 * Copyright (C) 2002, 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy.
 *
 * Thy is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * Thy is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file misc.h
 * Miscellaneous routine prototypes.
 */

#ifndef _THY_MISC_H
#define _THY_MISC_H 1 /**< misc.h multi-inclusion guard. */

#include "compat/compat.h"

#include "options.h"
#include "types.h"

void thy_priv_drop (uid_t uid);

char *userhome (const char *user);
char *userdir (const char *url, const char *udir);
size_t userpos (const char *url);
void urldecode (char *url);
const char *rfc822_date (time_t when);
#if THY_OPTION_LOGGING
const char *log_date (time_t when);
#endif
int follow_ifowner (const session_t *session);

#endif /* !_THY_MISC_H */
