/*
 *  Copyright (C) 2000 by Marco G"otze.
 *
 *  This code is part of the ThoughtTracker source package, which is
 *  distributed under the terms of the GNU GPL2.
 */

#ifndef OPTIONSDLG_H_INCLUDED
#define OPTIONSDLG_H_INCLUDED

#include <gtk--/button.h>
#include <gtk--/statusbar.h>
#include <gtk--/checkbutton.h>
#include <gtk--/window.h>

#include "thoughttracker.h"

class TTApplication;

class TTOptionsDialog : public Gtk::Window {
  public:
    TTOptionsDialog(TTApplication*);
    virtual ~TTOptionsDialog() {};

    /* runs the dialog */
    virtual void run();

    /* functions corresponding to buttons in the dialog */
    virtual void btn_set_font();
    virtual void btn_check_db();
    virtual void btn_clear_bm();

  private:
    struct {  // relevant widgets
      Gtk::Statusbar *sbar;
      Gtk::Button *done;
      struct {  // check buttons corresponding to options in app->opts
        Gtk::CheckButton *fixeddefault, *autolink, *quicksearch, *nolistlimit,
          *savesize;
      } o;
    } w;
    TTApplication *app;
    bool db_changes;  // changes made to the DB?
    bool done;  // done running

    /* outputs <msg> on the status bar */
    virtual void sbar_msg(string msg) const {
      w.sbar->push(w.sbar->get_context_id("status"), msg);
    }

    /* sets done to true */
    virtual void be_done() {
      done = true;
    }

    /* toggles a bool variable */
    virtual void toggle(Gtk::CheckButton *btn, bool *var) {
      *var = btn->get_active();
    }

    /* handles "delete" events */
    virtual int delete_event_impl(GdkEventAny *event) {
      done = true;
      return 0;
    }
};

#endif  /* OPTIONSDLG_H_INCLUDED */

