/*
 * defs.h - a header file for dvi2misc
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1998 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#define VERSION             "0.1.0"

#if STDC_HEADERS
#  include <string.h>
#  define memclr(a,n)      memset((a),0,(n))
#else
#  ifndef HAVE_MEMCMP
#    define memcmp(a1,a2,n)  bcmp((a1),(a2),(n))
#    define memclr(a,n)      bzero((a),(n))
#  else
#    define memclr(a,n)      memset((a),0,(n))
#  endif /*HAVE_MEMCMP*/
#endif 

#define  PROGRAM_TYPE_DVI2PGM      0   /* dvi2pgm, PGM */
#define  PROGRAM_TYPE_DVI2PPM      1   /* dvi2ppm, PPM */
#define  PROGRAM_TYPE_DVI2BDPS     2   /* dvi2bdps, PosctScript */
#define  PROGRAM_TYPE_DVI2ESCPG    3   /* dvi2escp, Epson ESC/Page */
#define  PROGRAM_TYPE_DVI2RPDL     4   /* dvi2rpdl, Ricoh RPDL */

/* output formats for dvi2pgm */
#define  DEFAULT_OUT_FORMAT        10  /* PGM RAW */
#define  OUT_FORMAT_PGM_RAW        10  /* PGM RAW */
#define  OUT_FORMAT_PGM_ASCII      11  /* PGM ASCII */
#define  OUT_FORMAT_PPM_RAW        12  /* PPM RAW */
#define  OUT_FORMAT_PPM_ASCII      13  /* PPM ASCII, not supprted for now */
#define  OUT_FORMAT_EPS            20  /* EPS, not supprted for now */

#define SYS_OFFSET_X  1.0
#define SYS_OFFSET_Y  1.0

#define  TRUE    (1==1)
#define  FALSE   (1==0)

#define PR0(s)       fprintf(stderr, s);
#define PR1(s,a)     fprintf(stderr, s, a);
#define PR2(s,a,b)   fprintf(stderr, s, a, b);
#define PR3(s,a,b,c) fprintf(stderr, s, a, b, c);

struct s_paper {
  char    *name;
  int      id;
  double   w, h;
};


extern int               interrupted;
extern DVI               dvi;
extern DVI_DEVICE        dev;
extern DVI_FRAME_BUFFER  framebuff;
extern FILE             *output_fp;
extern struct s_paper    paper_list[];
extern char             *program_name;
extern char             *program_desc;
extern char             *param_dvi_file;
extern int               param_dpi;
extern int               param_landscape;
extern int               param_doubleside
;
extern double            param_offset_x;
extern double            param_offset_y;
extern char             *param_paper_name;
extern int               param_paper_id;
extern int               param_num_copies;
extern int               param_page_from;
extern int               param_page_to;
extern int               param_page_rev;
extern int               param_debug;


extern FILE  *output_file_fopen(char *ofile);
extern void   output_file_fclose(char *ofile, FILE *fp);


/*EOF*/
