#include <stdio.h>
#include <stdlib.h>

static int processline(char *line, char **start, char **end, int *systemheader)
{
	const char *include_text = "include";
	char *current = line;
	*start = 0;
	*end = 0;
	*systemheader = 0;
	
	/* search for # */
	while(*current != '#')
	{
		if(*current == ' ' || *current == '\t')
			current++; /* next char */
		else
			return 0; /* this catches \0 aswell */
	}
	
	current++; /* skip # */
	
	/* search for first character */
	while(1)
	{
		if(*current == ' ' || *current == '\t')
			current++;
		else if(*current == 0)
			return 0;
		else
			break;
	}
	
	/* match "include" */
	while(*include_text)
	{
		if(*current == *include_text)
		{
			current++;
			include_text++;
		}
		else
			return 0;
	}
	
	/* search for first character */
	while(1)
	{
		if(*current == ' ' || *current == '\t')
			current++;
		else if(*current == 0)
			return 0;
		else
			break;
	}

	/* match starting < or " */
	*start = current+1;
	if(*current == '<')
		*systemheader = 1;
	else if(*current == '"')
		*systemheader = 0;
	else
		return 0;
	
	/* skip < or " */
	current++;
	
	/* search for < or " to end it */
	while(1)
	{
		if(*current == '>' || *current == '"')
			break;
		else if(*current == 0)
			return 0;
		else
			current++;
	}
	
	*end = current; 

	return 1;
}

/* dependency calculator for c/c++ preprocessor */
int dependency_cpp_run(const char *filename, 
		int (*callback)(void *, const char *, int), void *userdata)
{
	const int debug = 0;
	char *linestart;
	char *includestart;
	char *includeend;
	int systemheader;
	int errorcode = 0;
	int linecount = 0;

	/* open file */
	long filesize;
	long readitems;
	char *filebuf;
	char *filebufcur;
	char *filebufend;
	FILE *file;
	
	if(debug)
		printf("cpp-dep: running on %s\n", filename);

	file = fopen(filename, "rb");
	if(!file)
	{
		/* printf("cpp-dep: error opening %s\n", filename); */
		return 0;
	}
	
	/* read the whole file */		
	fseek(file, 0, SEEK_END);
	filesize = ftell(file);
	fseek(file, 0, SEEK_SET);
	
	filebuf = malloc(filesize+1); /* +1 for null termination */
	
	if(!filebuf)
	{
		printf("cpp-dep: error allocating %ld bytes\n", filesize);
		fclose(file);
		return 1;
	}
		
	/* read the file and close it */
	readitems = fread(filebuf, 1, filesize, file);
	fclose(file);

	if(readitems != filesize)
	{
		printf("cpp-dep: error reading the complete file. %ld of %ld bytes read\n", readitems, filesize);
		free(filebuf);
		return 1;
	}
	
	filebufcur = filebuf;
	filebufend = filebuf+filesize;
	
	while(filebufcur < filebufend)
	{
		/* search for next line */
		linestart = filebufcur;
		while(filebufcur != filebufend && *filebufcur != '\n' && *filebufcur != '\r')
			filebufcur++;
		*filebufcur = 0;
		filebufcur++;
		linecount++;

		if(processline(linestart, &includestart, &includeend, &systemheader))
		{
			*includeend = 0;
			if(debug) printf("INCLUDE: %s\n", includestart);
			
			/* run callback */
			errorcode = callback(userdata, includestart, systemheader);
			if(errorcode)
			{
				printf("cpp-dep: error %d during callback\n", errorcode);
				break;
			}
		}
	}

	if(debug)
		printf("cpp-dep: %s=%d lines\n", filename, linecount);
	
	/* clean up */
	free(filebuf);
	return errorcode;
}
