/************************************************************************/
/*									*/
/*  Font administration for a document.					*/
/*									*/
/************************************************************************/

#   include	"appUtilConfig.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<string.h>

#   define	y0	math_y0
#   define	y1	math_y1
#   include	<math.h>
#   undef	y0
#   undef	y1

#   include	<appDebugon.h>

#   include	"utilPropMask.h"
#   include	"utilTextAttribute.h"

/************************************************************************/
/*									*/
/*  Default value for text attributes.					*/
/*									*/
/************************************************************************/

TextAttribute	DocDefaultAttributes=
				{ -1, 24, 0, };

/************************************************************************/
/*									*/
/*  Set text attributes to a default value.				*/
/*									*/
/************************************************************************/

void docInitTextAttribute(	TextAttribute *	ta	)
    {
    ta->taFontNumber= -1;
    ta->taFontSizeHalfPoints= 0;
    ta->taFontIsBold= 0;
    ta->taFontIsSlanted= 0;
    ta->taIsUnderlined= 0;
    ta->taShowAsLink= 0;
    ta->taSuperSub= DOCfontREGULAR;
    ta->taSmallCaps= 0;
    ta->taHasStrikeThrough= 0;
    ta->taCapitals= 0;
    }

/************************************************************************/
/*									*/
/*  Get text attribute difference mask.					*/
/*									*/
/************************************************************************/

void docAttributeDifference(		PropertyMask *		pChangeMask,
					TextAttribute		taTo,
					TextAttribute		taFrom,
					const PropertyMask *	updMask )
    {
    PropertyMask	changeMask;

    if  ( ! updMask )
	{ XDEB(updMask); return;	}

    PROPmaskCLEAR( &changeMask );

    if  ( PROPmaskISSET( updMask, TApropFONTFAMILY )			&&
	  taTo.taFontNumber != taFrom.taFontNumber			)
	{ PROPmaskADD( &changeMask, TApropFONTFAMILY ); }

    if  ( PROPmaskISSET( updMask, TApropFONTSIZE )			&&
	  taTo.taFontSizeHalfPoints != taFrom.taFontSizeHalfPoints	)
	{ PROPmaskADD( &changeMask, TApropFONTSIZE ); }

    if  ( PROPmaskISSET( updMask, TApropFONTBOLD )			&&
	  taTo.taFontIsBold != taFrom.taFontIsBold			)
	{ PROPmaskADD( &changeMask, TApropFONTBOLD ); }

    if  ( PROPmaskISSET( updMask, TApropFONTSLANTED )			&&
	  taTo.taFontIsSlanted != taFrom.taFontIsSlanted		)
	{ PROPmaskADD( &changeMask, TApropFONTSLANTED ); }

    if  ( PROPmaskISSET( updMask, TApropTEXTUNDERLINED )		&&
	  taTo.taIsUnderlined != taFrom.taIsUnderlined			)
	{ PROPmaskADD( &changeMask, TApropTEXTUNDERLINED ); }

    if  ( PROPmaskISSET( updMask, TApropSHOWASLINK )			&&
	  taTo.taShowAsLink != taFrom.taShowAsLink			)
	{ PROPmaskADD( &changeMask, TApropSHOWASLINK ); }

    if  ( PROPmaskISSET( updMask, TApropSUPERSUB )			&&
	  taTo.taSuperSub != taFrom.taSuperSub				)
	{ PROPmaskADD( &changeMask, TApropSUPERSUB ); }

    if  ( PROPmaskISSET( updMask, TApropSMALLCAPS )			&&
	  taTo.taSmallCaps != taFrom.taSmallCaps			)
	{ PROPmaskADD( &changeMask, TApropSMALLCAPS ); }

    if  ( PROPmaskISSET( updMask, TApropCAPITALS )			&&
	  taTo.taCapitals != taFrom.taCapitals				)
	{ PROPmaskADD( &changeMask, TApropCAPITALS ); }

    if  ( PROPmaskISSET( updMask, TApropSTRIKETHROUGH )			&&
	  taTo.taHasStrikeThrough != taFrom.taHasStrikeThrough		)
	{ PROPmaskADD( &changeMask, TApropSTRIKETHROUGH ); }

    *pChangeMask= changeMask;
    return;
    }

void docUpdateTextAttribute(		PropertyMask *		pChangeMask,
					TextAttribute *		taTo,
					TextAttribute		taFrom,
					const PropertyMask *	updMask )
    {
    PropertyMask	changeMask= *pChangeMask;

    if  ( PROPmaskISSET( updMask, TApropFONTFAMILY )			&&
	  taTo->taFontNumber != taFrom.taFontNumber			)
	{
	taTo->taFontNumber= taFrom.taFontNumber;
	PROPmaskADD( &changeMask, TApropFONTFAMILY );
	}

    if  ( PROPmaskISSET( updMask, TApropFONTSIZE )			&&
	  taTo->taFontSizeHalfPoints != taFrom.taFontSizeHalfPoints	)
	{
	taTo->taFontSizeHalfPoints= taFrom.taFontSizeHalfPoints;
	PROPmaskADD( &changeMask, TApropFONTSIZE );
	}

    if  ( PROPmaskISSET( updMask, TApropFONTBOLD )			&&
	  taTo->taFontIsBold != taFrom.taFontIsBold			)
	{
	taTo->taFontIsBold= taFrom.taFontIsBold;	
	PROPmaskADD( &changeMask, TApropFONTBOLD );
	}

    if  ( PROPmaskISSET( updMask, TApropFONTSLANTED )			&&
	  taTo->taFontIsSlanted != taFrom.taFontIsSlanted		)
	{
	taTo->taFontIsSlanted= taFrom.taFontIsSlanted;
	PROPmaskADD( &changeMask, TApropFONTSLANTED );
	}

    if  ( PROPmaskISSET( updMask, TApropTEXTUNDERLINED )		&&
	  taTo->taIsUnderlined != taFrom.taIsUnderlined			)
	{
	taTo->taIsUnderlined= taFrom.taIsUnderlined;
	PROPmaskADD( &changeMask, TApropTEXTUNDERLINED );
	}

    if  ( PROPmaskISSET( updMask, TApropSHOWASLINK )			&&
	  taTo->taShowAsLink != taFrom.taShowAsLink			)
	{
	taTo->taShowAsLink= taFrom.taShowAsLink;
	PROPmaskADD( &changeMask, TApropSHOWASLINK );
	}

    if  ( PROPmaskISSET( updMask, TApropSUPERSUB )			&&
	  taTo->taSuperSub != taFrom.taSuperSub				)
	{
	taTo->taSuperSub= taFrom.taSuperSub;
	PROPmaskADD( &changeMask, TApropSUPERSUB );
	}

    if  ( PROPmaskISSET( updMask, TApropSMALLCAPS )			&&
	  taTo->taSmallCaps != taFrom.taSmallCaps			)
	{
	taTo->taSmallCaps= taFrom.taSmallCaps;
	PROPmaskADD( &changeMask, TApropSMALLCAPS );
	}

    if  ( PROPmaskISSET( updMask, TApropCAPITALS )			&&
	  taTo->taCapitals != taFrom.taCapitals				)
	{
	taTo->taCapitals= taFrom.taCapitals;
	PROPmaskADD( &changeMask, TApropCAPITALS );
	}

    if  ( PROPmaskISSET( updMask, TApropSTRIKETHROUGH )			&&
	  taTo->taHasStrikeThrough != taFrom.taHasStrikeThrough		)
	{
	taTo->taHasStrikeThrough= taFrom.taHasStrikeThrough;
	PROPmaskADD( &changeMask, TApropSTRIKETHROUGH );
	}

    *pChangeMask= changeMask;
    return;
    }

