#####################################################################
##
##   Look for zlib
##
#####################################################################

AC_DEFUN(AC_PATH_ZLIB,
[
    echo Checking for zlib...

    ZLIB_CFLAGS=
    ZLIB_LIBS=

    ac_zlib_includes=NO
    ac_zlib_libraries=NO

    # Includes
    for ac_dir in		\
	/usr/include		\
	/usr/local/include	\
	/usr/pkg/include	\
	/usr/local/include/zlib	\
	/usr/apps/include	\
	../zlib
    do
    if  test -r "$ac_dir/zlib.h"
	then
	    ac_zlib_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in		\
	/usr/lib		\
	/usr/local/lib		\
	/usr/pkg/lib		\
	/usr/local/lib/zlib	\
	/usr/apps/lib		\
	../zlib
    do
    if  test -r "$ac_dir/libz.a"
	then
	    ac_zlib_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_zlib_includes
    #echo Libraries: $ac_zlib_libraries

    if  test $ac_zlib_includes != NO
    then
	ZLIB_CFLAGS=-I$ac_zlib_includes
    fi

    if  test $ac_zlib_libraries != NO
    then
	ZLIB_LIBS="-L$ac_zlib_libraries"
    fi

    AC_SUBST(ZLIB_CFLAGS)dnl
    AC_SUBST(ZLIB_LIBS)dnl
])
#####################################################################
##
##   Find out whether there is a domein name in the struct utsname.
##   An what is is called
##
#####################################################################

AC_DEFUN(AC_STRUCT_UTSNAME_DOMAINNAME,
[
    dnl Is the domain in the utsname struct? What is it same..

    AC_TRY_LINK(
	[#include <sys/utsname.h>],
	[struct utsname u; return u.domainname;],
	AC_DEFINE(UTSNAME_DOMAIN,domainname),)
    AC_TRY_LINK(
	[#include <sys/utsname.h>],
	[struct utsname u; return u.__domainname;],
	AC_DEFINE(UTSNAME_DOMAIN,__domainname),)
])
