/************************************************************************/
/*									*/
/*  The 'Paragraph' page of the format tool.				*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<stddef.h>
#   include	<limits.h>

#   include	<appDebugon.h>

#   include	<appGeoString.h>
#   include	<appUnit.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

/************************************************************************/
/*									*/
/*  Update the controls for SpaceAbove/SpaceBelow.			*/
/*									*/
/************************************************************************/

static void tedFormatToolRefreshSpaceAround(	APP_WIDGET	text,
						APP_WIDGET	toggle,
						int		space )
    {
    char		scratch[50];

    if  ( space == 0 )
	{
	appStringToTextWidget( text, "" );
	appEnableText( text, 0 );

	appGuiSetToggleState( toggle, 0 );
	}
    else{
	appGeoLengthToString( scratch, space, UNITtyPOINTS );
	appStringToTextWidget( text, scratch );
	appEnableText( text, 1 );

	appGuiSetToggleState( toggle, 1 );
	}
    }

static void tedFormatToolRefreshParagraphPage(	ParagraphTool *	pt )
    {
    ParagraphProperties *	pp= &(pt->ptPropertiesChosen);

    char		scratch[50];

    appGeoLengthToString( scratch,
	    pp->ppLeftIndentTwips+ pp->ppFirstIndentTwips, UNITtyPOINTS );
    appStringToTextWidget( pt->ptFirstIndentText, scratch );

    appGeoLengthToString( scratch, pp->ppLeftIndentTwips, UNITtyPOINTS );
    appStringToTextWidget( pt->ptLeftIndentText, scratch );

    appGeoLengthToString( scratch, pp->ppRightIndentTwips, UNITtyPOINTS );
    appStringToTextWidget( pt->ptRightIndentText, scratch );

    tedFormatToolRefreshSpaceAround( pt->ptSpaceAboveText,
			    pt->ptSpaceAboveToggle, pp->ppSpaceBeforeTwips );

    tedFormatToolRefreshSpaceAround( pt->ptSpaceBelowText,
			    pt->ptSpaceBelowToggle, pp->ppSpaceAfterTwips );

    tedFormatReflectBorder( &(pt->ptTopBorderTool), &(pp->ppTopBorder) );
    tedFormatReflectBorder( &(pt->ptBottomBorderTool), &(pp->ppBottomBorder) );

    tedFormatRefreshHeightChooser( &(pt->ptLineDistChooser),
						    pp->ppLineSpacingTwips );

    appSetOptionmenu( &(pt->ptAlignOptionmenu), pp->ppAlignment );

    appGuiSetToggleState( pt->ptOnNewPageToggle, pp->ppStartsOnNewPage );
    appGuiSetToggleState( pt->ptOnOnePageToggle, pp->ppKeepOnPage );

    appGuiSetToggleState( pt->ptWidctrlToggle, pp->ppWidowControl );
    appGuiSetToggleState( pt->ptKeepWithNextToggle, pp->ppKeepWithNext );

#   if 0
    appSetOptionmenu( &(pt->ptShadingTool.stStyleOptionmenu),
						    pp->ppShadingPattern );
#   endif

    return;
    }


void tedFormatToolRefreshParagraphTool(
				ParagraphTool *			pt,
				int *				pEnabled,
				InspectorSubject *		is,
				const DocumentSelection *	ds )
    {
    const ParagraphProperties *		pp;

    PropertyMask			ppChgMask;
    PropertyMask			ppUpdMask;

    BufferItem *			bi= ds->dsBegin.dpBi;

    pp= &(bi->biParaProperties);

    PROPmaskCLEAR( &ppUpdMask );
    PROPmaskFILL( &ppUpdMask, PPprop_COUNT );
    PROPmaskUNSET( &ppUpdMask, PPpropIN_TABLE );

    PROPmaskCLEAR( &ppChgMask );

    if  ( docUpdParaProperties( &ppChgMask, &(pt->ptPropertiesChosen),
							    &ppUpdMask, pp ))
	{ LDEB(1); return ;	}

    PROPmaskCLEAR( &ppChgMask );

    if  ( docUpdParaProperties( &ppChgMask, &(pt->ptPropertiesSet),
							    &ppUpdMask, pp ))
	{ LDEB(1); return ;	}

    appGuiEnableWidget( pt->ptOnNewPageToggle,
			bi->biInExternalItem == DOCinBODY &&
			! pp->ppInTable );

    appGuiEnableWidget( is->isPrevButton,
				docPrevParagraph( bi ) != (BufferItem *)0 );
    appGuiEnableWidget( is->isNextButton,
				docNextParagraph( bi ) != (BufferItem *)0 );

    tedFormatToolRefreshParagraphPage( pt );

    *pEnabled= 1;
    return;
    }

/************************************************************************/
/*									*/
/*  The 'Revert' button on the paragraph tool has been pushed.		*/
/*									*/
/************************************************************************/

static void tedFormatParaRevertPushed(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;

    PropertyMask		ppChgMask;
    PropertyMask		ppUpdMask;

    PROPmaskCLEAR( &ppChgMask );

    PROPmaskCLEAR( &ppUpdMask );
    PROPmaskFILL( &ppUpdMask, PPprop_COUNT );

    docUpdParaProperties( &ppChgMask, &(pt->ptPropertiesChosen),
					&ppUpdMask, &(pt->ptPropertiesSet) );

    tedFormatToolRefreshParagraphPage( pt );

    return;
    }

/************************************************************************/
/*									*/
/*  Check user input.							*/
/*									*/
/************************************************************************/

static void tedParaFirstIndentChanged(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    ParagraphProperties *	pp= &(pt->ptPropertiesChosen);

    int				lipfi;
    int				changed;

    lipfi=  pp->ppLeftIndentTwips+ pp->ppFirstIndentTwips;

    tedFormatValidateDimension( &lipfi, &changed, w, lipfi );

    return;
    }

static void tedParaLeftIndentChanged(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    ParagraphProperties *	pp= &(pt->ptPropertiesChosen);

    int				value;
    int				changed;

    tedFormatValidateDimension( &value, &changed, w, pp->ppLeftIndentTwips );

    return;
    }

static void tedParaRightIndentChanged(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    ParagraphProperties *	pp= &(pt->ptPropertiesChosen);

    int				value;
    int				changed;

    tedFormatValidateDimension( &value, &changed, w, pp->ppRightIndentTwips );

    return;
    }

static void tedParaSpaceAboveChanged(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    ParagraphProperties *	pp= &(pt->ptPropertiesChosen);

    int				value;
    int				changed;

    tedFormatValidateDimension( &value, &changed, w, pp->ppSpaceBeforeTwips );

    return;
    }

static void tedParaSpaceBelowChanged(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    ParagraphProperties *	pp= &(pt->ptPropertiesChosen);

    int				value;
    int				changed;

    tedFormatValidateDimension( &value, &changed, w, pp->ppSpaceAfterTwips );

    return;
    }

static void tedParaLineDistanceChanged(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    ParagraphProperties *	pp= &(pt->ptPropertiesChosen);

    int				value;
    int				changed;

    tedFormatValidateDimension( &value, &changed, w, pp->ppLineSpacingTwips );

    return;
    }

/************************************************************************/
/*									*/
/*  Previous/Next Paragraph buttons have been pushed.			*/
/*									*/
/************************************************************************/

static void tedFormatPrevPara(		APP_WIDGET	w,
					void *		voidpt,
					void *		voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    EditApplication *		ea= pt->ptApplication;

    tedSelectWholeParagraph( ea, -1 );

    return;
    }

static void tedFormatNextPara(		APP_WIDGET	w,
					void *		voidpt,
					void *		voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    EditApplication *		ea= pt->ptApplication;

    tedSelectWholeParagraph( ea, 1 );

    return;
    }

static void tedFormatSelectPara(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    EditApplication *		ea= pt->ptApplication;

    tedSelectWholeParagraph( ea, 0 );

    return;
    }

static void tedFormatDeletePara(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    EditApplication *		ea= pt->ptApplication;

    tedDeleteCurrentParagraph( ea );
    }

static void tedFormatInsertPara(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    EditApplication *		ea= pt->ptApplication;

    tedInsertParagraph( ea, 0 );

    return;
    }

static void tedFormatAppendPara(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    EditApplication *		ea= pt->ptApplication;

    tedInsertParagraph( ea, 1 );

    return;
    }

/************************************************************************/
/*									*/
/*  The 'Change' button on the paragraph page has been pushed.		*/
/*									*/
/************************************************************************/

static int tedFormatToolGetSpaceAround(		int *		pValue,
						int *		pChanged,
						APP_WIDGET	text,
						APP_WIDGET	toggle,
						int		value )
    {
    int			state;
    int			changed= 0;

    const int		minValue= 1;
    const int		adaptToMin= 0;
    const int		maxValue= INT_MAX;
    const int		adaptToMax= 0;

    state= appGuiGetToggleState( toggle ) != 0;
    if  ( ! state )
	{ *pChanged= ( value != 0 ); *pValue= 0; return 0;	}

    state= value;
    if  ( appGetLengthFromTextWidget( text,
			    &state, &changed, UNITtyPOINTS,
			    minValue, adaptToMin, maxValue, adaptToMax ) )
	{ return -1;	}

    if  ( changed )
	{ value= state;	}

    *pChanged= changed; *pValue=value; return 0;
    }

static void tedFormatChangePara(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidpbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    EditApplication *		ea= pt->ptApplication;
    ParagraphProperties *	pp= &(pt->ptPropertiesChosen);

    int				li;
    int				lipfi;

    int				value;
    int				changed;

    PropertyMask		ppUpdMask;

    const int			maxValue= INT_MAX;
    const int			adaptToMax= 0;

    PROPmaskCLEAR( &ppUpdMask );
    PROPmaskFILL( &ppUpdMask, PPprop_COUNT );
    PROPmaskUNSET( &ppUpdMask, PPpropIN_TABLE );

    lipfi= pp->ppLeftIndentTwips+ pp->ppFirstIndentTwips;
    if  ( appGetLengthFromTextWidget( pt->ptFirstIndentText,
					&lipfi, &changed, UNITtyPOINTS,
					INT_MIN, 0, maxValue, adaptToMax ) )
	{ return;	}

    li= pp->ppLeftIndentTwips;
    if  ( appGetLengthFromTextWidget( pt->ptLeftIndentText,
					&li, &changed, UNITtyPOINTS,
					1, 1, maxValue, adaptToMax ) )
	{ return;	}

    pp->ppLeftIndentTwips= li;
    pp->ppFirstIndentTwips= lipfi- li;

    value= pp->ppRightIndentTwips;
    if  ( appGetLengthFromTextWidget( pt->ptRightIndentText,
					&value, &changed, UNITtyPOINTS,
					1, 1, maxValue, adaptToMax ) )
	{ return;	}
    pp->ppRightIndentTwips= value;

    value= pp->ppLineSpacingTwips;
    if  ( tedFormatToolGetHeight( &value, &(pt->ptLineDistChooser) ) )
	{ return;	}
    pp->ppLineSpacingTwips= value;

    value= pp->ppSpaceBeforeTwips;
    if  ( tedFormatToolGetSpaceAround( &value, &changed,
			pt->ptSpaceAboveText, pt->ptSpaceAboveToggle, value ) )
	{ return;	}
    pp->ppSpaceBeforeTwips= value;

    value= pp->ppSpaceAfterTwips;
    if  ( tedFormatToolGetSpaceAround( &value, &changed,
			pt->ptSpaceBelowText, pt->ptSpaceBelowToggle, value ) )
	{ return;	}
    pp->ppSpaceAfterTwips= value;

    if  ( tedBorderToolGetWidth( &(pt->ptTopBorderTool),
						&(pp->ppTopBorder) ) )
	{ return;	}

    if  ( tedBorderToolGetWidth( &(pt->ptBottomBorderTool),
						&(pp->ppBottomBorder) ) )
	{ return;	}

    if  ( tedAppChangeParagraphProperties( ea, &ppUpdMask, pp ) )
	{ LDEB(1);	}

    return;
    }

/************************************************************************/
/*									*/
/*  One of the Space toggles was activated:				*/
/*									*/
/************************************************************************/

static void tedFormatSpaceAboveToggled(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidtbcs )
    {
    ParagraphTool *			pt= (ParagraphTool *)voidpt;
    ParagraphProperties *		pp= &(pt->ptPropertiesChosen);

    int					set;

    set= appGuiGetToggleStateFromCallback( w, voidtbcs );

    if  ( set )
	{
	if  ( pt->ptPropertiesSet.ppSpaceBeforeTwips != 0 )
	    {
	    pp->ppSpaceBeforeTwips=
			    pt->ptPropertiesSet.ppSpaceBeforeTwips;
	    }
	else{
	    EditDocument *	ed= pt->ptApplication->eaCurrentDocument;
	    int			lineHeight;

	    if  ( ! ed || tedGetParaLineHeight( &lineHeight, ed ) )
		{ XLDEB(ed,set);			}
	    else{ pp->ppSpaceBeforeTwips= lineHeight;	}
	    }
	}
    else{
	pp->ppSpaceBeforeTwips= 0;
	}

    tedFormatToolRefreshSpaceAround( pt->ptSpaceAboveText,
		    pt->ptSpaceAboveToggle, pp->ppSpaceBeforeTwips );

    return;
    }

static void tedFormatSpaceBelowToggled(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidtbcs )
    {
    ParagraphTool *			pt= (ParagraphTool *)voidpt;
    ParagraphProperties *		pp= &(pt->ptPropertiesChosen);
    
    int					set;

    set= appGuiGetToggleStateFromCallback( w, voidtbcs );

    if  ( set )
	{
	if  ( pt->ptPropertiesSet.ppSpaceAfterTwips != 0 )
	    {
	    pp->ppSpaceAfterTwips=
			    pt->ptPropertiesSet.ppSpaceAfterTwips;
	    }
	else{
	    EditDocument *	ed= pt->ptApplication->eaCurrentDocument;
	    int			lineHeight;

	    if  ( ! ed || tedGetParaLineHeight( &lineHeight, ed ) )
		{ XLDEB(ed,set);			}
	    else{ pp->ppSpaceAfterTwips= lineHeight;	}
	    }
	}
    else{
	pp->ppSpaceAfterTwips= 0;
	}

    tedFormatToolRefreshSpaceAround( pt->ptSpaceBelowText,
		    pt->ptSpaceBelowToggle, pp->ppSpaceAfterTwips );

    return;
    }

static void tedParaAlignmentChosen(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidtbcs )
    {
    ParagraphTool *			pt= (ParagraphTool *)voidpt;
    ParagraphProperties *		pp= &(pt->ptPropertiesChosen);

    int					alignment= -1;

    for ( alignment= 0; alignment < DOCia_COUNT; alignment++ )
	{
	if  ( pt->ptAlignItems[alignment] == w )
	    { break;	}
	}

    if  ( alignment >= 0 && alignment < DOCia_COUNT )
	{ pp->ppAlignment= alignment;		}
    else{ LLDEB(alignment,DOCia_COUNT);	}

    return;
    }

#   if 0
static void tedParaShadingChosen(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidtbcs )
    {
    ParagraphTool *			pt= (ParagraphTool *)voidpt;
    ParagraphProperties *		pp= &(pt->ptPropertiesChosen);

    int					shading= -1;

    for ( shading= 0; shading < DOCsp_COUNT; shading++ )
	{
	if  ( pt->ptShadingTool.stStyleItems[shading] == w )
	    { break;	}
	}

    if  ( shading >= 0 && shading < DOCsp_COUNT )
	{ pp->ppShadingPattern= shading;		}
    else{ LLDEB(shading,DOCsp_COUNT);			}

    return;
    }
#   endif

static void tedParaBorderStyleChosen(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidtbcs )
    {
    ParagraphTool *			pt= (ParagraphTool *)voidpt;
    ParagraphProperties *		pp= &(pt->ptPropertiesChosen);

    if  ( ! tedBorderToolGetStyle( &(pt->ptTopBorderTool),
						&(pp->ppTopBorder), w ) )
	{ return;	}

    if  ( ! tedBorderToolGetStyle( &(pt->ptBottomBorderTool),
						&(pp->ppBottomBorder), w ) )
	{ return;	}

    XDEB(w); return;
    }

/************************************************************************/
/*									*/
/*  A line Spacing was chosen with the menu.				*/
/*									*/
/************************************************************************/

static void tedParaLineDistChosen(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidtbcs )
    {
    ParagraphTool *			pt= (ParagraphTool *)voidpt;

    int			defaultValue;

    defaultValue= pt->ptPropertiesChosen.ppLineSpacingTwips;
    if  ( defaultValue == 0 )
	{ defaultValue= pt->ptPropertiesSet.ppLineSpacingTwips;	}
    if  ( defaultValue == 0 )
	{ defaultValue= 240;	}

    tedFormatHeightChosen( w, &(pt->ptLineDistChooser), defaultValue );

    return;
    }

/************************************************************************/
/*									*/
/*  One of the 'Paragraph Border' toggles has been activated.		*/
/*									*/
/************************************************************************/

static void tedParagraphToggleChanged(	APP_WIDGET	w,
					void *		voidpt,
					void *		voidtbcs )
    {
    ParagraphTool *		pt= (ParagraphTool *)voidpt;
    ParagraphProperties *	pp= &(pt->ptPropertiesChosen);

    int				set;
    const int			influenceStyleMenu= 1;

    set= appGuiGetToggleStateFromCallback( w, voidtbcs );

    if  ( w == pt->ptTopBorderTool.btOnOffToggle )
	{
	tedFormatToggleBorder( &(pp->ppTopBorder), &(pt->ptTopBorderTool),
						    influenceStyleMenu, set );
	return;
	}

    if  ( w == pt->ptBottomBorderTool.btOnOffToggle )
	{
	tedFormatToggleBorder( &(pp->ppBottomBorder), &(pt->ptBottomBorderTool),
						    influenceStyleMenu, set );
	return;
	}

    if  ( w == pt->ptOnNewPageToggle )
	{
	pp->ppStartsOnNewPage= ( set != 0 ) && ! pp->ppInTable;

	return;
	}

    if  ( w == pt->ptOnOnePageToggle )
	{
	pp->ppKeepOnPage= ( set != 0 );

	return;
	}

    if  ( w == pt->ptWidctrlToggle )
	{
	pp->ppWidowControl= ( set != 0 );

	return;
	}

    if  ( w == pt->ptKeepWithNextToggle )
	{
	pp->ppKeepWithNext= ( set != 0 );

	return;
	}

    XDEB(w); return;
    }

/************************************************************************/
/*									*/
/*  Make the paragraph page.						*/
/*									*/
/************************************************************************/

void tedFormatFillParagraphPage( ParagraphTool *		pt,
				const ParagraphPageResources *	ppr,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources *	isr )
    {
    APP_WIDGET		firstLabel;
    APP_WIDGET		leftLabel;
    APP_WIDGET		rightLabel;
    APP_WIDGET		alignLabel;

    APP_WIDGET		row;

    const int		textColumns= 10;

    /**/
    pt->ptPageResources= ppr;

    /**/
    docInitParagraphProperties( &(pt->ptPropertiesSet) );
    docInitParagraphProperties( &(pt->ptPropertiesChosen) );

    /**/
    appMakeLabelAndTextRow( &row, &firstLabel, &(pt->ptFirstIndentText),
		    pageWidget, ppr->pprParaFirstIndent, textColumns, 1 );

    appGuiSetGotValueCallbackForText( pt->ptFirstIndentText,
				    tedParaFirstIndentChanged, (void *)pt );
    /**/
    appMakeLabelAndTextRow( &row, &leftLabel, &(pt->ptLeftIndentText),
		    pageWidget, ppr->pprParaLeftIndent, textColumns, 1 );

    appGuiSetGotValueCallbackForText( pt->ptLeftIndentText,
				    tedParaLeftIndentChanged, (void *)pt );
    /**/
    appMakeLabelAndTextRow( &row, &rightLabel, &(pt->ptRightIndentText),
		    pageWidget, ppr->pprParaRightIndent, textColumns, 1 );

    appGuiSetGotValueCallbackForText( pt->ptRightIndentText,
				    tedParaRightIndentChanged, (void *)pt );
    /**/
    appInspectorMakeMenuRow( &row, &(pt->ptAlignOptionmenu),
		    &alignLabel, pageWidget, ppr->pprParaAlignment );

    /**/
    tedFormatMakeHeightRow( &row, (void *)pt, pageWidget,
		    &(pt->ptLineDistChooser), tedParaLineDistanceChanged );

    /**/
    appMakeToggleAndTextRow( &row, &(pt->ptSpaceAboveToggle),
		    &(pt->ptSpaceAboveText), pageWidget,
		    ppr->pprParaSpaceAbove,
		    tedFormatSpaceAboveToggled, (void *)pt,
		    textColumns, 1 );

    appGuiSetGotValueCallbackForText( pt->ptSpaceAboveText,
				    tedParaSpaceAboveChanged, (void *)pt );
    /**/
    appMakeToggleAndTextRow( &row, &(pt->ptSpaceBelowToggle),
		    &(pt->ptSpaceBelowText), pageWidget,
		    ppr->pprParaSpaceBelow,
		    tedFormatSpaceBelowToggled, (void *)pt,
		    textColumns, 1 );

    appGuiSetGotValueCallbackForText( pt->ptSpaceBelowText,
				    tedParaSpaceBelowChanged, (void *)pt );

    /**/
    tedFormatMakeBorderTool( &(pt->ptTopBorderTool), &row, pageWidget,
		ppr->pprTopBorder, tedParagraphToggleChanged, (void *)pt );

    tedFormatMakeBorderTool( &(pt->ptBottomBorderTool), &row, pageWidget,
		ppr->pprBottomBorder, tedParagraphToggleChanged, (void *)pt );

#   if 0
    /**/
    tedFormatMakeShadingTool( &(pt->ptShadingTool), &row,
				    pageWidget, ppr->pprShadingPattern );
#   endif


    /**/
    appInspectorMakeToggleRow( &row, pageWidget,
		    &(pt->ptOnNewPageToggle), &(pt->ptOnOnePageToggle),
		    ppr->pprOnNewPage, ppr->pprOnOnePage,
		    tedParagraphToggleChanged,
		    tedParagraphToggleChanged, (void *)pt );

    /*
    appGuiEnableWidget( pt->ptOnOnePageToggle, 0 );
    */

    /**/
    appInspectorMakeToggleRow( &row, pageWidget,
		    &(pt->ptWidctrlToggle), &(pt->ptKeepWithNextToggle),
		    ppr->pprWidctrl, ppr->pprKeepWithNext,
		    tedParagraphToggleChanged,
		    tedParagraphToggleChanged, (void *)pt );

    /**/
    appInspectorMakeButtonRow( &row, pageWidget,
			&(is->isPrevButton), &(is->isNextButton),
			isr->isrPrevButtonText, isr->isrNextButtonText,
			tedFormatPrevPara, tedFormatNextPara, pt );

    appInspectorMakeButtonRow( &row, pageWidget,
			&(is->isSelectButton), &(is->isDeleteButton),
			isr->isrSelectButtonText, isr->isrDeleteButtonText,
			tedFormatSelectPara, tedFormatDeletePara, pt );

    appInspectorMakeButtonRow( &row, pageWidget,
			&(is->isInsertButton), &(is->isAppendButton),
			isr->isrInsertButtonText, isr->isrAppendButtonText,
			tedFormatInsertPara, tedFormatAppendPara, pt );

    appInspectorMakeButtonRow( &row, pageWidget,
			&(is->isRevertButton), &(is->isApplyButton),
			isr->isrRevert, isr->isrApplyToSubject,
			tedFormatParaRevertPushed, tedFormatChangePara, pt );

    return;
    }

/************************************************************************/
/*									*/
/*  Finish the paragraph page.						*/
/*									*/
/************************************************************************/

void tedFormatFillParagraphChoosers(	ParagraphTool *			pt,
					const ParagraphPageResources *	ppr )
    {
    tedFormatFillHeightChooser( &(pt->ptLineDistChooser),
					    tedParaLineDistChosen, pt,
					    ppr->pprParaLineDistFree,
					    ppr->pprParaLineDistAtLeast,
					    ppr->pprParaLineDistExactly );

    appFillInspectorMenu( DOCia_COUNT, DOCiaLEFT,
			pt->ptAlignItems, ppr->pprParaAlignMenuTexts,
			&(pt->ptAlignOptionmenu),
			tedParaAlignmentChosen, (void *)pt );

#   if 0
    tedFormatFillShadingTool( &(pt->ptShadingTool),
					tedParaShadingChosen, (void *)pt );
#   endif

    tedFormatFillBorderTool( &(pt->ptTopBorderTool),
					tedParaBorderStyleChosen, (void *)pt );

    tedFormatFillBorderTool( &(pt->ptBottomBorderTool),
					tedParaBorderStyleChosen, (void *)pt );

    return;
    }

void tedFormatFinishParagraphPage(	ParagraphTool *			pt,
					TedFormatTool *			tft,
					const ParagraphPageResources *	ppr )
    {
    appOptionmenuRefreshWidth( &(pt->ptLineDistChooser.hcOptionmenu) );

    appOptionmenuRefreshWidth( &(pt->ptAlignOptionmenu) );

#   if 0
    tedFormatFinishShadingTool( &(pt->ptShadingTool), tft );
#   endif

    tedFormatFinishBorderTool( &(pt->ptTopBorderTool), tft );
    tedFormatFinishBorderTool( &(pt->ptBottomBorderTool), tft );

    return;
    }

/************************************************************************/
/*									*/
/*  Get paragraph tool resources.					*/
/*									*/
/************************************************************************/

static AppConfigurableResource TED_TedParagraphSubjectResourceTable[]=
    {
    APP_RESOURCE( "formatToolPara",
	offsetof(InspectorSubjectResources,isrSubjectName),
	"Paragraph" ),
    APP_RESOURCE( "formatToolChangePara",
	offsetof(InspectorSubjectResources,isrApplyToSubject),
	"Apply to Paragraph" ),
    APP_RESOURCE( "tableToolRevert",
	offsetof(InspectorSubjectResources,isrRevert),
	"Revert" ),
    APP_RESOURCE( "formatToolNextPara",
	offsetof(InspectorSubjectResources,isrNextButtonText),
	"Next Paragraph" ),
    APP_RESOURCE( "formatToolPreviousPara",
	offsetof(InspectorSubjectResources,isrPrevButtonText),
	"Previous Paragraph" ),
    APP_RESOURCE( "formatToolSelectPara",
	offsetof(InspectorSubjectResources,isrSelectButtonText),
	"Select Paragraph" ),
    APP_RESOURCE( "formatToolDeletePara",
	offsetof(InspectorSubjectResources,isrDeleteButtonText),
	"Delete Paragraph" ),
    APP_RESOURCE( "formatToolInsertPara",
	offsetof(InspectorSubjectResources,isrInsertButtonText),
	"Insert Paragraph" ),
    APP_RESOURCE( "formatToolAppendPara",
	offsetof(InspectorSubjectResources,isrAppendButtonText),
	"Append Paragraph" ),
    };

static AppConfigurableResource TED_TedParagraphToolResourceTable[]=
    {
    /**/
    APP_RESOURCE( "formatToolParaFirstIndent",
	offsetof(ParagraphPageResources,pprParaFirstIndent),
	"First Line Indent" ),
    APP_RESOURCE( "formatToolParaLeftIndent",
	offsetof(ParagraphPageResources,pprParaLeftIndent),
	"Left Indent" ),
    APP_RESOURCE( "formatToolParaRightIndent",
	offsetof(ParagraphPageResources,pprParaRightIndent),
	"Right Indent" ),
    /**/
    APP_RESOURCE( "formatToolParaAlignment",
	offsetof(ParagraphPageResources,pprParaAlignment),
	"Alignment" ),
    APP_RESOURCE( "formatToolParaAlignLeft",
	offsetof(ParagraphPageResources,pprParaAlignMenuTexts[DOCiaLEFT]),
	"Left" ),
    APP_RESOURCE( "formatToolParaAlignRight",
	offsetof(ParagraphPageResources,pprParaAlignMenuTexts[DOCiaRIGHT]),
	"Right" ),
    APP_RESOURCE( "formatToolParaAlignCentered",
	offsetof(ParagraphPageResources,pprParaAlignMenuTexts[DOCiaCENTERED]),
	"Centered" ),
    APP_RESOURCE( "formatToolParaAlignJustified",
	offsetof(ParagraphPageResources,pprParaAlignMenuTexts[DOCiaJUSTIFIED]),
	"Justified" ),
    /**/
    APP_RESOURCE( "formatToolLineDistFree",
	offsetof(ParagraphPageResources,pprParaLineDistFree),
	"Spacing Free" ),
    APP_RESOURCE( "formatToolLineDistExactly",
	offsetof(ParagraphPageResources,pprParaLineDistExactly),
	"Spacing Exactly" ),
    APP_RESOURCE( "formatToolLineDistAtLeast",
	offsetof(ParagraphPageResources,pprParaLineDistAtLeast),
	"Spacing at Least" ),
    /**/
    APP_RESOURCE( "formatToolParaSpaceAbove",
	offsetof(ParagraphPageResources,pprParaSpaceAbove),
	"Space Above" ),
    APP_RESOURCE( "formatToolParaSpaceBelow",
	offsetof(ParagraphPageResources,pprParaSpaceBelow),
	"Space Below" ),
    /**/
    APP_RESOURCE( "formatToolParaTopBorder",
	offsetof(ParagraphPageResources,pprTopBorder),
	"Top Border" ),
    APP_RESOURCE( "formatToolParaBottomBorder",
	offsetof(ParagraphPageResources,pprBottomBorder),
	"Bottom Border" ),
    /**/
    APP_RESOURCE( "tableToolParaShadingPattern",
	offsetof(ParagraphPageResources,pprShadingPattern),
	"Shading Pattern" ),
    /**/
    APP_RESOURCE( "formatToolParaOnNewPage",
	offsetof(ParagraphPageResources,pprOnNewPage),
	"Start on New Page" ),
    APP_RESOURCE( "formatToolParaOnOnePage",
	offsetof(ParagraphPageResources,pprOnOnePage),
	"Keep on One Page" ),
    /**/
    APP_RESOURCE( "formatToolParaWidctrl",
	offsetof(ParagraphPageResources,pprWidctrl),
	"Widow/Orphan Control" ),
    APP_RESOURCE( "formatToolParaKeepWithNext",
	offsetof(ParagraphPageResources,pprKeepWithNext),
	"Keep with Next" ),
    };

void tedFormatToolGetParaResourceTable(	EditApplication *		ea,
					ParagraphPageResources *	ppr,
					InspectorSubjectResources *	isr )
    {
    appGuiGetResourceValues( ea, (void *)ppr,
				TED_TedParagraphToolResourceTable,
				sizeof(TED_TedParagraphToolResourceTable)/
				sizeof(AppConfigurableResource) );

    appGuiGetResourceValues( ea, (void *)isr,
				TED_TedParagraphSubjectResourceTable,
				sizeof(TED_TedParagraphSubjectResourceTable)/
				sizeof(AppConfigurableResource) );

    return;
    }
