'\"
'\" Generated from tsv.tmml
'\"
'\" BEGIN man.macros
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.de DS
.RS
.nf
.sp
..
.de DE
.fi
.RE
.sp
..
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
.if t .ft C
..
.de CE
.fi
.if t .ft R
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
'\" END man.macros
.TH "Tcl Threading" n "2.5" Tcl ""
.BS
.SH NAME
tsv \- Part of the Tcl threading extension allowing script-level manipulation
of data shared between threads in a simple, safe and protected fashion.
.SH SYNOPSIS
.nf


.PP

\&\fBpackage require Thread ?2.5?\fP

\&\fBtsv::names\fP ?\fIpattern\fR?
\&\fBtsv::object\fP \fIarray\fR \fIelement\fR
\&\fBtsv::set\fP \fIarray\fR \fIelement\fR \fIvalue\fR 
\&\fBtsv::get\fP \fIarray\fR \fIelement\fR ?\fIvarname\fR?
\&\fBtsv::unset\fP \fIarray\fR ?\fIelement\fR?
\&\fBtsv::exists\fP \fIarray\fR ?\fIelement\fR?
\&\fBtsv::pop\fP \fIarray\fR \fIelement\fR
\&\fBtsv::move\fP \fIarray\fR \fIold\fR \fInew\fR
\&\fBtsv::incr\fP \fIarray\fR \fIelement\fR ?\fIincrement\fR?
\&\fBtsv::append\fP \fIarray\fR \fIelement\fR \fIvalue\fR ?\fIvalue\fR ...?
\&\fBtsv::lappend\fP \fIarray\fR \fIelement\fR \fIvalue\fR ?\fIvalue\fR ...?
\&\fBtsv::linsert\fP \fIarray\fR \fIelement\fR \fIindex\fR \fIvalue\fR ?\fIvalue\fR ...?
\&\fBtsv::lreplace\fP \fIarray\fR \fIelement\fR \fIfirst\fR \fIlast\fR ?\fIvalue\fR ...?
\&\fBtsv::llength\fP \fIarray\fR \fIelement\fR
\&\fBtsv::lindex\fP \fIarray\fR \fIelement\fR \fIindex\fR
\&\fBtsv::lrange\fP \fIarray\fR \fIelement\fR \fIfirst\fR \fIlast\fR
\&\fBtsv::lsearch\fP \fIarray\fR \fIelement\fR ?\fImode\fR? \fIpattern\fR
\&\fBtsv::lpop\fP \fIarray\fR \fIelement\fR ?\fIindex\fR?
\&\fBtsv::lpush\fP \fIarray\fR \fIelement\fR \fIvalue\fR ?\fIindex\fR?
\&\fBtsv::lock\fP \fIarg\fR ?\fIarg ...\fR?

.fi
.BE
.SH DESCRIPTION
.PP
This section describes commands implementing thread shared variables. A thread
shared variable is very similar to a Tcl array but in contrast to a Tcl array
it is created in thread-shared memory and can be accessed from many threads at
the same time. Important feature of thread shared variable is that each access
to the variable is internaly protected by a mutex so script programmer does not have
to take care about locking the variable himself.
.PP
Thread shared variables are not bound to any thread explicitly. That means that
when a thread which created any of thread shared variables exits, the variable
and associated memory is not unset/reclaimed. User has to explicitly unset the
variable to reclaim the memory consumed by the variable.
.SH COMMANDS
.TP
\&\fB\fBtsv::names\fP
\&\fRReturns names of shared variables matching optional \fIpattern\fR or all known
variables if pattern is ommited. The \fBtsv::names\fP returns an empty list on
process start. All thread shared variables are created by explicit user action.
.TP
\&\fB\fBtsv::object\fP
\&\fRCreates object accessor command for the \fIelement\fR in the given shared 
\&\fIarray\fR. Using this command, one can apply most of the other shared variable
commands as method functions of the element object command. The object command is
automatically deleted when the element which this command is pointing to is unset.

.RS
.CS

% tsv::set foo bar "A shared string"
% set string [tsv::object foo bar]
% $string append " appended"
=> A shared string appended
.CE
.RE
.TP
\&\fB\fBtsv::set\fP
\&\fRSets the value of the \fIelement\fR  in the shared \fIarray\fR to
\&\fIvalue\fR and returns the value. The \fIvalue\fR may be ommited, and
the command will return the current value of the \fIelement\fR. If the
element cannot be found, error is triggered.
.TP
\&\fB\fBtsv::get\fP
\&\fRRetrieves a value of the \fIelement\fR located in the shared \fIarray\fR.
The command triggers error if the \fIelement\fR is not found. If the optional
\&\fIvarname\fR is given, the value  is stored in the named variable. In this case,
the command returns true (1) if \fIelement\fR is found or false (0) if the
\&\fIelement\fR is not found.
.TP
\&\fB\fBtsv::unset\fP
\&\fRDeletes the \fIelement\fR in the shared \fIarray\fR. If the \fIelement\fR
is not given, it deletes the whole \fIarray\fR.
.TP
\&\fB\fBtsv::exists\fP
\&\fRChecks wether the \fIelement\fR exists in the shared \fIarray\fR.
If the \fIelement\fR is not given it tests the existence of the
\&\fIarray\fR itself. Returns true (1) if the item exists,
false (0) if not.
.TP
\&\fB\fBtsv::pop\fP
\&\fRReturns value of the \fIelement\fR in the shared \fIarray\fR variable
and unsets the \fIelement\fR in one atomic operation.
.TP
\&\fB\fBtsv::move\fP
\&\fRRenames the element \fIold\fR to \fInew\fR in the shared \fIarray\fR.
This effectively performs an get/unset/set sequence of operations
but in one atomic step.
.TP
\&\fB\fBtsv::incr\fP
\&\fRSimilar to standard Tcl \fBincr\fP but increments the value of the
\&\fIelement\fR in shared \fIarray\fR instead of the Tcl variable.
.TP
\&\fB\fBtsv::append\fP
\&\fRSimilar to standard Tcl \fBappend\fP but appends one or more values
to the \fIelement\fR in the shared \fIarray\fR instead of the Tcl variable.
.TP
\&\fB\fBtsv::lappend\fP
\&\fRSimilar to standard Tcl \fBlappend\fP but appends one or more values
to the list \fIelement\fR in the shared \fIarray\fR instead of the Tcl variable.
.TP
\&\fB\fBtsv::linsert\fP
\&\fRSimilar to standard Tcl \fBlinsert\fP but inserts one or more values at the
\&\fIindex\fR list position in the list \fIelement\fR in the shared \fIarray\fR
instead of the Tcl variable.
.TP
\&\fB\fBtsv::lreplace\fP
\&\fRSimilar to standard Tcl \fBlreplace\fP but replaces one or more values
from the list \fIelement\fR in the shared \fIarray\fR instead of the Tcl variable.
.TP
\&\fB\fBtsv::llength\fP
\&\fRSimilar to standard Tcl \fBllength\fP but returns length of the list
\&\fIelement\fR in the shared \fIarray\fR instead of the Tcl variable.
.TP
\&\fB\fBtsv::lindex\fP
\&\fRSimilar to standard Tcl \fBlindex\fP but returns value at the \fIindex\fR
list position from the list \fIelement\fR in the shared \fIarray\fR
instead of the Tcl variable.
.TP
\&\fB\fBtsv::lrange\fP
\&\fRSimilar to standard Tcl \fBlrange\fP but returns values between \fIfirst\fR
and \fIlast\fR list position from the list \fIelement\fR in the shared \fIarray\fR
instead of the Tcl variable.
.TP
\&\fB\fBtsv::lsearch\fP
\&\fRSimilar to standard Tcl \fBlsearch\fP but searches the list \fIelement\fR
in the shared \fIarray\fR instead of the Tcl variable.
.TP
\&\fB\fBtsv::lpop\fP
\&\fRSplices out the value at the \fIindex\fR list position from the list \fIelement\fR
in the shared \fIarray\fR. If \fIindex\fR is not specified, it defaults to zero.
.TP
\&\fB\fBtsv::lpush\fP
\&\fRInserts the \fIvalue\fR at the \fIindex\fR list position in the list \fIelement\fR
in the shared \fIarray\fR. If \fIindex\fR is not specified, it defaults to zero.
.TP
\&\fB\fBtsv::lock\fP
\&\fRThis command concatenates passed arguments and evaluates the
resulting script under the internal mutex protection. During the
script evaluation, the entire shared array is locked. For shared
variable commands within the script, internal locking is disabled
so no deadlock can occur. It is also allowed to unset the shared
variable from within the script. The shared variable is automatically
created if it did not exists at the time of the first lock operation.

.RS
.CS

% tsv::lock foo {
    # Atomically append two elements
    tsv::lappend foo bar 1
    tsv::lappend foo bar 2
    puts stderr [tsv::array get foo]
    tsv::unset foo
}
%
.CE
.RE
.TP
\&\fB\fBtsv::array\fP
\&\fRThis command supports most of the options of the standard Tcl \fBarray\fP
command like:
.RS
.TP
\&\fB\fBtsv::array set\fP
\&\fRDoes the same as standard Tcl \fBarray set\fR
.TP
\&\fB\fBtsv::array get\fP
\&\fRDoes the same as standard Tcl \fBarray get\fR
.TP
\&\fB\fBtsv::array names\fP
\&\fRDoes the same as standard Tcl \fBarray names\fR
.TP
\&\fB\fBtsv::array size\fP
\&\fRDoes the same as standard Tcl \fBarray size\fR
.TP
\&\fB\fBtsv::array reset\fP
\&\fRDoes the same as standard Tcl \fBarray set\fR but
it clears the array and sets new values atomically.
.RE
.SH DISCUSSION
.PP
The current implementation of thread shared variables allows easy and
convenient access to data to be shared between different threads.
Internally, the data is stored in Tcl objects and all package commands
operate on internal data representation, thus minimizing shimmering and
improving performance. Special care has been taken in assuring that all
object data is properly locked and copied when moving objects between threads.
.PP
Due to the internal design of the Tcl core, there is no provision of full
integration of shared variables within the Tcl syntax, unfortunately. All
access to shared data must be performed with the supplied package commands.
Also, variable traces are not supported. But even so, benefits of easy,
simple and safe shared data manipulation outweights imposed limitations.
.SH CREDITS
.PP
Thread shared variables are inspired by the nsv interface found in
AOLserver 3.+ highly scalable Web server from America Online.
.SH "SEE ALSO"
Guide to the Tcl threading model
.SH KEYWORDS
threads, synchronization, locking, thread shared data
