;;; tc-complete.el --- completion with T-Code

;; Copyright (C) 2001 KITAJIMA Akira.

;; Author: KITAJIMA Akira <kitajima@isc.osakac.ac.jp>
;; Maintainer: KITAJIMA Akira
;; Keyword: completion
;; Created: Jul 31, 2001

;; $Id: tc-complete.el,v 1.8 2002/03/11 01:43:59 kitajima Exp $

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.

;;; Code:

(require 'tc)

(defcustom tcode-complete-kouho-max 3
  "*䴰κݤκ"
  :type 'integer :group 'tcode)

(defcustom tcode-complete-context-length-min 3
  "*䴰κݤʸ̮κǾĹ"
  :type 'integer :group 'tcode)

(defcustom tcode-complete-context-length-max 8
  "*䴰κݤʸ̮κĹ"
  :type 'integer :group 'tcode)

(defcustom tcode-complete-dictionary-name
  (concat tcode-data-directory "complete.dic")
  "*䴰Υѥ̾"
  :type 'string :group 'tcode)
(defconst tcode-complete-buffer-name " *tcode: complete dictionary*")
;; 䴰ΥХåե̾

;;; Ͽ
(unless (assq tcode-complete-buffer-name tcode-dictionaries)
  (setq tcode-dictionaries (cons (cons tcode-complete-buffer-name
				       tcode-complete-dictionary-name)
				 tcode-dictionaries)))

(defvar tcode-complete-kouho-list nil)
;; 䴰ݻѿ
(make-variable-buffer-local 'tcode-complete-kouho-list)

(defvar tcode-complete-self-insert-command-list
  '(self-insert-command tcode-self-insert-command-maybe)
  "䴰õäˤʤ륳ޥɤΥꥹȡ")

;;;
;;; 
;;;

;;;###autoload
(defun tcode-complete-reload-dictionary ()
  "䴰ɤ߹ߤ롣"
  (interactive)
  (tcode-set-work-buffer tcode-complete-buffer-name
			 tcode-complete-dictionary-name
			 t))

(defun tcode-complete-lookup (prefix)
  "䴰Ѽ񤫤PREFIXĸõ"
  (save-excursion
    (tcode-set-work-buffer tcode-complete-buffer-name
			   tcode-complete-dictionary-name)
    (goto-char (point-min))
    (let ((prefix-regexp (concat "^" (regexp-quote prefix)))
	  kouho-list)
      (catch 'overflow
	(while (search-forward-regexp prefix-regexp nil t)
	  (beginning-of-line)
	  (let ((kouho (if (looking-at "^.+ \\(.+\\)$")
			   (buffer-substring (match-beginning 1)
					     (match-end 1))
			 (buffer-substring (point)
					   (progn (end-of-line) (point))))))
	    (unless (string= kouho prefix)
	      (setq kouho-list (cons kouho kouho-list))
	      (if (> (length kouho-list) tcode-complete-kouho-max)
		  (throw 'overflow nil))))
	  (forward-line 1))
	(reverse kouho-list)))))

(defun tcode-complete-switch-to-dictionary ()
  "Хåե䴰Ѽڤؤ롣"
  (interactive)
  (switch-to-buffer
   (tcode-set-work-buffer tcode-complete-buffer-name
			  tcode-complete-dictionary-name)))

(defun tcode-complete-add-to-dictionary (beg end)
  "꡼ǻꤷ䴰ѼϿ롣"
  (interactive "r")
  (let ((str (buffer-substring beg end)))
    (save-excursion
      (tcode-set-work-buffer tcode-complete-buffer-name
			     tcode-complete-dictionary-name)
      (goto-char (point-min))
      (insert str "\n"))))

;;;
;;; 䴰
;;;

;;;###autoload
(defun tcode-complete-insert (n)
  "ߤʸ̮Ǥϸ롣
Nꤵ줿ϡNܤθˤʤ롣"
  (interactive "*p")
  (when tcode-complete-kouho-list
    (delete-region (car (car tcode-complete-kouho-list)) (point))
    (insert (nth (if (>= n 0)
		     (1- n)
		   (+ (length (cdr tcode-complete-kouho-list)) n))
		 (cdr tcode-complete-kouho-list)))
    (tcode-do-auto-fill)
    (tcode-complete-display)))

(global-set-key (kbd "M-RET") 'tcode-complete-insert)

;;;
;;; 䴰
;;;

(defun tcode-complete-get-context ()
  "ߤΥݥȤʸ̮롣
ʸ̮ϥꥹȹ¤ǤꡢꥹȤǤ(POINT . \"ʸ\")Ǥ롣
ǡʸפϡPOINTϤޤ븽ߤΥݥȤޤǤʸǤ롣
ʸĹ`tcode-complete-context-length-max'ޤǤǤ롣"
  (let ((raw-context (tcode-get-context tcode-complete-context-length-max))
	context)
    (while raw-context
      (setq context (cons (cons (car (car raw-context))
				(mapconcat 'cdr raw-context ""))
			  context)
	    raw-context (cdr raw-context)))
    (reverse context)))

(defun tcode-complete-search-kouho (context)
  "񤫤ʸ̮˹礦õ"
  (catch 'found
    (while context
      (let ((kouho (tcode-complete-lookup (cdr (car context)))))
	(if kouho
	    (throw 'found (cons (car context) kouho))))
      (setq context (cdr context)))))

(defun tcode-complete-make-kouho-list-string (kouho-list)
  "䴰ΥꥹȤɽʸ롣"
  (format ">%s%s<\n"
	  (car kouho-list)
	  (if (cdr kouho-list)
	      (concat " ["
		      (let ((count 1))
			(mapconcat (lambda (kouho)
				     (format "%d)%s"
					     (setq count (1+ count))
					     kouho))
				   (cdr kouho-list)
				   " "))
		      "]")
	    "")))

(defun tcode-complete-display ()
  "ߤʸ̮Ǥϸɽ롣"
  (interactive)
  (let* ((kouhoes (tcode-complete-search-kouho (tcode-complete-get-context)))
	 (real-kouho-list (cdr kouhoes))
	 (prefix (cdr (car kouhoes)))
	 (nok (length real-kouho-list)))
    (if (or (> nok tcode-complete-kouho-max)
	    (< (length (tcode-string-to-char-list prefix))
	       tcode-complete-context-length-min))
	(setq tcode-complete-kouho-list nil)
      (setq tcode-complete-kouho-list kouhoes)
      (when (and kouhoes
		 (not (window-minibuffer-p (selected-window))))
	(unwind-protect
	    (progn
	      (tcode-overlay-message
	       (tcode-complete-make-kouho-list-string real-kouho-list))
	      (tcode-verbose-message (tcode-substitute-command-keys
				      "\\[tcode-complete-insert]פ䴰"))
	      (sit-for 5))
	  (tcode-delete-overlay-message))))))

(defun tcode-complete-display-function ()
  (if (and (tcode-on-p)
	   (memq last-command tcode-complete-self-insert-command-list))
      (tcode-complete-display)))

(add-hook 'post-command-hook 'tcode-complete-display-function)

(provide 'tc-complete)

;;; tc-complete.el ends here
