/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998, 1999  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Or look at http://www.gnu.org/copyleft/gpl.html .

**********************************************************************/
/* $Id: show_true_function_values.c,v 1.3 1999/01/15 02:19:14 lance Exp $ */
#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <stdlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>

#include "xwin.h"
#include "data.h"


extern GC band_gc;

extern int get_window_size(Display *display, Window window, 
			    unsigned int *width, 
			    unsigned int *height);
/* returns 1 on failure */
extern int get_pointer_postion(PlotXwins *win, int *xi, int *yi);
extern void show_fn_vals_undraw(PlotXwins *win, Plot *plot,
			 unsigned int width, unsigned int height,
			 unsigned int h1);
extern void show_pt_vals_undraw(PlotXwins *win, Plot *plot,
			 unsigned int width, unsigned int height,
			 unsigned int w1, unsigned int h1);
/* redraw flag */
static int show_true_function_values_undraw = 0;
static int sf_xi=-2; /* last postion of virtical line */
extern int check_popWig(PlotXwins *win, Plot *plot);


void unset_show_true_fn_vals_undraw(void) /* draw_plot() in plot.c calls this */
{
  show_true_function_values_undraw = 0;
}

void show_true_fn_vals_undraw(PlotXwins *win, Plot *plot,
			 unsigned int width, unsigned int height,
			 unsigned int h1)
{
  if(show_true_function_values_undraw && sf_xi>-1 && sf_xi<width)
    XDrawLine(win->display,win->plotwin,band_gc, sf_xi,0,sf_xi,h1);
  show_true_function_values_undraw = 0;
}


/* Blocks until it get an event */
/* returns 0 if button is pressed or released else returns 1 */
static int look_for_Button(PlotXwins *win, int button)
{
  XEvent event;

  XWindowEvent(win->display,win->plotwin,
	       PointerMotionMask | ButtonReleaseMask | ButtonPressMask,&event);
  switch(event.type)
    {
    case ButtonPress:
    case ButtonRelease:
      if(event.xbutton.button == button)
	return 0;
      return 1;
    default:
      return 1;
    }
}


static void print_true_fn_values(PlotXwins *win, Plot *plot, int xi,
				 unsigned int *xout)
{
  int i;
  char str[100];
  double x,y,m;
  static struct Data **dx = NULL,**dy = NULL;

  if(dx == NULL)
    {
      assert(NULL != (dx = (struct Data **) malloc(sizeof(struct Data *)*plot->num_plots)));
      assert(NULL != (dy = (struct Data **) malloc(sizeof(struct Data *)*plot->num_plots)));
      for(i=0;i<plot->num_plots;i++)
	{
	  dx[i] = plot->start[plot->zoom_count][i][X];
	  dy[i] = plot->start[plot->zoom_count][i][Y];
	}
    }

  for(i=0;i<plot->num_plots;i++)
    {
      if(!(plot->plot_opt[i] & PHASE_PLOT))
	{
	  x = ((xi - plot->z_shift[plot->zoom_count][X])/
	       plot->z_scale[plot->zoom_count][X] -
	       plot->shift[i][X])/plot->scale[i][X];

	  while(dx[i]->val < x && dx[i]->next != NULL)
	    {
	      dx[i] = dx[i]->next;
	      dy[i] = dy[i]->next;
	    }

	  while(dx[i]->val > x && dx[i]->prev != NULL)
	    {
	      dx[i] = dx[i]->prev;
	      dy[i] = dy[i]->prev;
	    }

	  if((dx[i]->prev == NULL && x<=dx[i]->val)|| 
	     (dx[i]->next == NULL && x>=dx[i]->val))
	    {
	      x = dx[i]->val;
	      y = dy[i]->val;
	    }
	  else 
	    {
	      m = (dy[i]->val - (dy[i]->next)->val)/
		(dx[i]->val - (dx[i]->next)->val);/* slope */
	      y = m*x + dy[i]->val - m*dx[i]->val;
	      /* now I have the interpulated values lets get the closest vals */
	      if((x - dx[i]->val) > ((dx[i]->next)->val - x))
		{
		  x = (dx[i]->next)->val;
		  y = (dy[i]->next)->val;
		}
	      else
		{
		  x = dx[i]->val;
		  y = dy[i]->val;
		}
	    }
	  /* lance fix this , no need to do this for every i */
	  *xout = ( plot->scale[i][X]*x + plot->shift[i][X] )*
		     plot->z_scale[plot->zoom_count][X] +
		     plot->z_shift[plot->zoom_count][X];
	  sprintf(str,"%15.15g %15.15g = (%s X, %s Y )",
		     x,y, plot->label[plot->list[i][X]],
		  plot->label[plot->list[i][Y]]);
	}
      else /* it's a phase plot */
	{
	  sprintf(str,"%s X  %s Y is a phase plot. Try the right mouse.",
		      plot->label[plot->list[i][X]],plot->label[plot->list[i][Y]]);
	}
      XtVaSetValues(win->valueWig[i],XtNstring,str, NULL);
    }
}

/* need to clean up this algorithm
 * the xout_save variable is kind of yucky
 * but it works fine.
 */
void show_true_function_values(PlotXwins *win, Plot *plot, int button)
{
  int y,x;
  unsigned int width, height,w1,h1;
  unsigned int xout, xout_save;

  get_window_size(win->display,win->plotwin,&width,&height);
  h1 = height -1; w1 = width -1;
  if(get_pointer_postion(win,&x,&y))
    {
      fprintf(stderr,"quickplot ERROR: can't get pointer position: file %s line %d\n",
	      __FILE__,__LINE__ -3);
      return;
    }

  show_fn_vals_undraw(win,plot,width,height,h1);
  show_pt_vals_undraw(win,plot,width,height,w1,h1);
  show_true_fn_vals_undraw(win,plot,width,height,h1);


  check_popWig(win,plot);
  print_true_fn_values(win,plot,x, &xout);

  if(x>-1 && x<width)
    XDrawLine(win->display,win->plotwin,band_gc, xout,0,xout,h1);
  XFlush(win->display);

  sf_xi = x;
  xout_save = xout;
  while(look_for_Button(win, button))
    {
      if(get_pointer_postion(win,&x,&y))
	{
	  fprintf(stderr,"quickplot ERROR: can't get pointer position: file %s line %d\n",
		  __FILE__,__LINE__ -3);
	  return;
	}
      if(x!=sf_xi && x>-1 && x<width)
	{
	  print_true_fn_values(win,plot, x, &xout);
	  if(xout != xout_save)
	    {
	      XDrawLine(win->display,win->plotwin,band_gc, xout_save,0,xout_save,h1);
	      XDrawLine(win->display,win->plotwin,band_gc, xout,0,xout,h1);
	      XFlush(win->display);
	      xout_save = xout;
	    }
	  sf_xi = x;
	}
    }
  XFlush(win->display);
  sf_xi = xout;
  show_true_function_values_undraw = 1;
}
