=begin
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
=end

# $Id: cliquet_option.rb,v 1.4 2002/01/16 15:17:06 nando Exp $

require 'QuantLib'
require 'runit/testcase'
require 'runit/testsuite'
require 'runit/cui/testrunner'

class CliquetOptionTest < RUNIT::TestCase
    def name
        "Testing Cliquet option pricer..."
    end
    def test
        spot = 100
        divYield = 0.01
        rRate = 0.06
        dates = [0.50, 1.00, 2.00]
        vol = 0.35
        euro1 = QuantLib::EuropeanOption.new("Call", spot, spot, divYield,
                    rRate, dates[1]-dates[0], vol)
        w1 = Math.exp(divYield*dates[0])

        euro2 = QuantLib::EuropeanOption.new("Call", spot, spot, divYield,
                    rRate, dates[2]-dates[1], vol)
        w2 = Math.exp(divYield*dates[1])

        cliquet = QuantLib::CliquetOption.new("Call", spot, divYield, rRate,
                      dates, vol)

        ['value', 'delta', 'gamma', 'theta', 'rho', 'vega'].each { |method|
            expected = w1*euro1.send(method) + w2*euro2.send(method)
            calculated = cliquet.send(method)
            unless (calculated-expected).abs <= 1.0e-10
                assert_fail(<<-MESSAGE

    wrong #{method}:
        calculated: #{calculated}
        expected  : #{expected}

                    MESSAGE
                )
            end
        }
    end
end

if $0 == __FILE__
    RUNIT::CUI::TestRunner.run(CliquetOptionTest.suite)
end

