=begin
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
=end

# $Id: binary_option.rb,v 1.4 2002/01/16 15:17:06 nando Exp $

require 'QuantLib'
require 'runit/testcase'
require 'runit/testsuite'
require 'runit/cui/testrunner'

def relErr(x1,x2,reference)
    if reference != 0.0
        (x1-x2).abs/reference
    else
        1.0e+10
    end
end

class BinaryOptionTest < RUNIT::TestCase
    def name
        "Testing binary option pricer..."
    end
    def test
        # errors allowed for Greeks
        error = {
            'delta' => 2.0e-3,
            'gamma' => 2.0e-3,
            'theta' => 2.0e-3,
            'rho'   => 2.0e-3,
            'dividendRho' => 2.0e-3,
            'vega'  => 2.0e-3
        }

        pricer = QuantLib::BinaryOption

        ['Call','Put','Straddle'].each                         { |type|
        [100].each                                             { |under|
        [0.04, 0.05, 0.06].each                                { |qRate|
        [1.0].each                                             { |resTime|
        [0.01, 0.05, 0.15].each                                { |rRate|
        [50, 99.5, 100, 100.5, 150].each                       { |strike|
        [0.11, 0.5, 1.2].each                                  { |vol|
            # check Greeks
            dS = under/10000.0
            dT = resTime/10000.0
            dVol = vol/10000.0
            dR = rRate/10000.0
            dQ = qRate/10000.0
            opt = pricer.new(type,under,strike,qRate,rRate,resTime,vol)
            opt_val = opt.value
            if opt_val > 1.0e-6
                optPs = pricer.new(type, under+dS, strike, qRate, rRate,
                                   resTime ,vol)
                optMs = pricer.new(type, under-dS, strike, qRate, rRate,
                                   resTime, vol)
                optPt = pricer.new(type, under, strike, qRate, rRate,
                                   resTime+dT, vol)
                optMt = pricer.new(type, under, strike, qRate, rRate,
                                   resTime-dT, vol)
                optPr = pricer.new(type, under, strike, qRate, rRate+dR,
                                   resTime, vol)
                optMr = pricer.new(type, under, strike, qRate, rRate-dR,
                                   resTime, vol)
                optPq = pricer.new(type, under, strike, qRate+dQ, rRate,
                                   resTime, vol)
                optMq = pricer.new(type, under, strike, qRate-dQ, rRate,
                                   resTime, vol)
                optPv = pricer.new(type, under, strike, qRate, rRate,
                                   resTime, vol+dVol)
                optMv = pricer.new(type, under, strike, qRate, rRate,
                                   resTime, vol-dVol)
                # numeric values
                results = {
                    'delta' =>  (optPs.value - optMs.value)/(2*dS),
                    'gamma' =>  (optPs.delta - optMs.delta)/(2*dS),
                    'theta' => -(optPt.value - optMt.value)/(2*dT),
                    'rho'   =>  (optPr.value - optMr.value)/(2*dR),
                    'dividendRho' => (optPq.value - optMq.value)/(2*dQ),
                    'vega' =>   (optPv.value - optMv.value)/(2*dVol)
                }

                ['delta','gamma','theta','rho','dividendRho','vega'].each { |greek|
                    unless relErr(opt.send(greek),results[greek],under) <= error[greek]
                        assert_fail(<<-MESSAGE

    Option details: #{type} #{under} #{strike} #{qRate} #{rRate} #{resTime} #{vol}
        value  = #{opt_val}
        #{greek} = #{opt.send(greek)}, #{greek}Num = #{results[greek]}

                            MESSAGE
                        )
                    end
                }
            end
        }}}}}}}
    end
end

if $0 == __FILE__
    RUNIT::CUI::TestRunner.run(BinaryOptionTest.suite)
end
