

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/


// $Id: Pricers.i,v 1.5 2002/01/16 14:51:31 nando Exp $

#ifndef quantlib_pricers_i
#define quantlib_pricers_i

%include Date.i
%include Types.i
%include Vectors.i
%include Options.i

%{
using QuantLib::Pricers::FdAmericanOption;
using QuantLib::Pricers::BinaryOption;
using QuantLib::Pricers::FdBermudanOption;
using QuantLib::Pricers::EuropeanOption;
using QuantLib::Pricers::CliquetOption;
using QuantLib::Pricers::FdEuropean;
using QuantLib::Pricers::FdDividendAmericanOption;
using QuantLib::Pricers::FdDividendEuropeanOption;
using QuantLib::Pricers::FdDividendShoutOption;
using QuantLib::Pricers::FdShoutOption;
using QuantLib::Pricers::BarrierOption;
using QuantLib::Pricers::DiscreteGeometricAPO;
using QuantLib::Pricers::DiscreteGeometricASO;
using QuantLib::Pricers::ContinuousGeometricAPO;
%}


class EuropeanOption {
  public:
	EuropeanOption(OptionType type, double underlying, double strike,
	  Spread dividendYield, Rate riskFreeRate, Time residualTime,
	  double volatility);
	~EuropeanOption();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
	double impliedVolatility(double targetValue, double accuracy = 1e-4,
	  int maxEvaluations = 100) const ;
};


class CliquetOption {
  public:
	CliquetOption(OptionType type,
                  double underlying,
                  Spread dividendYield,
                  Rate riskFreeRate,
                  const DoubleVector &times,
                  double volatility);
	~CliquetOption();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
	double impliedVolatility(double targetValue,
	                         double accuracy = 1e-4,
	                         int maxEvaluations = 100) const ;
};

class FdEuropean {
  public:
	FdEuropean(OptionType type, double underlying,
	  double strike, Spread dividendYield, Rate riskFreeRate,
	  Time residualTime, double volatility, int timeSteps = 200,
	  int gridPoints = 800);
	~FdEuropean();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
	double impliedVolatility(double targetValue, double accuracy = 1e-4,
	  int maxEvaluations = 100) const ;
};

class BinaryOption {
  public:
	BinaryOption(OptionType type, double underlying, double strike,
	  Spread dividendYield, Rate riskFreeRate, Time residualTime,
	  double volatility, double cashPayoff = 1.0);
	~BinaryOption();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
	double impliedVolatility(double targetValue, double accuracy = 1e-4,
	  int maxEvaluations = 100) const ;
};

class FdAmericanOption {
  public:
	FdAmericanOption(OptionType type, double underlying, double strike,
	  Spread dividendYield, Rate riskFreeRate, Time residualTime,
	  double volatility, int timeSteps = 100, int gridPoints = 100);
    ~FdAmericanOption();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
	double impliedVolatility(double targetValue, double accuracy = 1e-4,
                             int maxEvaluations = 100) const ;
};

class FdShoutOption {
  public:
	FdShoutOption(OptionType type, double underlying, double strike,
	  Spread dividendYield, Rate riskFreeRate, Time residualTime,
	  double volatility, int timeSteps = 100, int gridPoints = 100);
    ~FdShoutOption();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
	double impliedVolatility(double targetValue, double accuracy = 1e-4,
                             int maxEvaluations = 100) const ;
};


class FdBermudanOption{
  public:
	FdBermudanOption(OptionType type, double underlying, double strike,
	  Spread dividendYield, Rate riskFreeRate, Time residualTime,
	  double volatility, const DoubleVector &times,
	  int timeSteps = 100, int gridPoints = 100);
	~FdBermudanOption();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
	double impliedVolatility(double targetValue, double accuracy = 1e-4,
	  int maxEvaluations = 100) const ;
};

class FdDividendShoutOption{
  public:
	FdDividendShoutOption(OptionType type, double underlying, double strike,
	  Spread dividendYield, Rate riskFreeRate, Time residualTime,
	  double volatility,
	  const DoubleVector &dividends,
	  const DoubleVector &exdivtimes,
	  int timeSteps = 100, int gridPoints = 100);
	~FdDividendShoutOption();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
	double impliedVolatility(double targetValue, double accuracy = 1e-4,
	  int maxEvaluations = 100) const ;
};

class FdDividendAmericanOption {
  public:
	FdDividendAmericanOption(OptionType type, double underlying, double strike,
	  Spread dividendYield, Rate riskFreeRate, Time residualTime,
	  double volatility,
	  const DoubleVector &dividends,
	  const DoubleVector &exdivtimes,
	  int timeSteps = 100, int gridPoints = 100);
	~FdDividendAmericanOption();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
	double impliedVolatility(double targetValue, double accuracy = 1e-4,
	  int maxEvaluations = 100) const ;
};

class FdDividendEuropeanOption {
  public:
	FdDividendEuropeanOption(OptionType type, double underlying, double strike,
	  Spread dividendYield, Rate riskFreeRate, Time residualTime,
	  double volatility,
	  const DoubleVector &dividends,
	  const DoubleVector &exdivtimes);
	~FdDividendEuropeanOption();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
	double impliedVolatility(double targetValue, double accuracy = 1e-4,
	  int maxEvaluations = 100) const ;
};

class ContinuousGeometricAPO {
  public:
	ContinuousGeometricAPO(OptionType type, double underlying,
		double strike,
		Spread dividendYield, Rate riskFreeRate, double residualTime,
		double volatility);
    ~ContinuousGeometricAPO();
	double value() const;
};

class DiscreteGeometricAPO {
  public:
	DiscreteGeometricAPO(OptionType type,
                         double underlying,
                         double strike,
                         Spread dividendYield,
                         Rate riskFreeRate,
                         const DoubleVector& timeDelays,
                         double volatility);
    ~DiscreteGeometricAPO();
	double value() const;
};

class DiscreteGeometricASO {
  public:
	DiscreteGeometricASO(OptionType type,
                         double underlying,
                         Spread dividendYield,
                         Rate riskFreeRate,
                         const DoubleVector& timeDelays,
                         double volatility);
    ~DiscreteGeometricASO();
	double value() const;
};


// barrier option type

%{
typedef QuantLib::Pricers::BarrierOption::BarrierType BarrierType;
using QuantLib::StringFormatter;
%}

%typemap(ruby,in) BarrierType (BarrierType temp),
                  const BarrierType & (BarrierType temp) {
    if (TYPE($source) == T_STRING) {
        std::string s(STR2CSTR($source));
        s = StringFormatter::toLowercase(s);
        if      (s == "downin")     temp = BarrierOption::DownIn;
        else if (s == "downout")    temp = BarrierOption::DownOut;
        else if (s == "upin")       temp = BarrierOption::UpIn;
        else if (s == "upout")      temp = BarrierOption::UpOut;
        else rb_raise(rb_eTypeError,"unknown barrier type");
    } else {
        rb_raise(rb_eTypeError,"not a barrier type");
    }
    $target = &temp;
};


class BarrierOption {
  public:
    BarrierOption(BarrierType barrType, OptionType type, double underlying,
        double strike, Spread dividendYield, Rate riskFreeRate,
        Time residualTime, double volatility, double barrier,
        double rebate = 0.0);
    ~BarrierOption();
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
    double value() const;
};


#endif
