

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Options.i,v 1.6 2002/01/16 14:51:31 nando Exp $

#ifndef quantlib_options_i
#define quantlib_options_i

%include Instruments.i
%include MarketElements.i
%include TermStructures.i
%include Types.i

// typemap option types to corresponding strings

%{
using QuantLib::Option;
typedef Option::Type OptionType;
using QuantLib::StringFormatter;
%}

%typemap(ruby,in) OptionType (OptionType temp),
                  const OptionType & (OptionType temp) {
    if (TYPE($source) == T_STRING) {
        std::string s(STR2CSTR($source));
        s = StringFormatter::toLowercase(s);
        if (s == "c" || s == "call")          temp = Option::Call;
        else if (s == "p" || s == "put")      temp = Option::Put;
        else if (s == "s" || s == "straddle") temp = Option::Straddle;
        else {
            rb_raise(rb_eTypeError,"unknown option type");
        }
    } else {
        rb_raise(rb_eTypeError,"not an option type");
    }
    $target = &temp;
};

%typemap(ruby,out) OptionType, const OptionType & {
    switch (*$source) {
      case Option::Call:     $target = rb_str_new2("Call");     break;
      case Option::Put:      $target = rb_str_new2("Put");      break;
      case Option::Straddle: $target = rb_str_new2("Straddle"); break;
    }
};

%typemap(ruby,ret) OptionType {
    delete $source;
}


// handles to pricing engines

%{
using QuantLib::OptionPricingEngine;
typedef Handle<OptionPricingEngine> OptionEngineHandle;
%}

class OptionEngineHandle {
  private:
    // abstract class - no constructor
    OptionEngineHandle();
  public:
    ~OptionEngineHandle();
};


// plain options and engines

%{
using QuantLib::Instruments::PlainOption;
typedef Handle<PlainOption> PlainOptionHandle;
%}

// fake inheritance
%name(PlainOption) class PlainOptionHandle : public InstrumentHandle {
  public:
    // constructor redefined below
    ~PlainOptionHandle();
};

%addmethods PlainOptionHandle {
    void crash() {}
    PlainOptionHandle(OptionType type,
        MarketElementRelinkableHandle underlying, double strike,
        TermStructureRelinkableHandle dividendYield,
        TermStructureRelinkableHandle riskFreeRate,
        Date exerciseDate,
        MarketElementRelinkableHandle volatility,
        OptionEngineHandle engine) {
            return new PlainOptionHandle(new PlainOption(type,underlying,
                strike,dividendYield,riskFreeRate,exerciseDate,volatility,
                engine,"","option"));
    }
    double delta() {
        return (*self)->delta();
    }
    double gamma() {
        return (*self)->gamma();
    }
    double theta() {
        return (*self)->theta();
    }
    double vega() {
        return (*self)->vega();
    }
    double rho() {
        return (*self)->rho();
    }
    double dividendRho() {
        return (*self)->dividendRho();
    }
    double impliedVolatility(double targetValue, double accuracy = 1.0e-4,
                             size_t maxEvaluations = 100,
                             double minVol = 1.0e-4, double maxVol = 4.0) {
        return (*self)->impliedVolatility(
            targetValue,accuracy,maxEvaluations,minVol,maxVol);
    }
}

%{
using QuantLib::Pricers::EuropeanEngine;
typedef Handle<EuropeanEngine> EuropeanEngineHandle;
%}

// fake inheritance
%name(EuropeanEngine) class EuropeanEngineHandle : public OptionEngineHandle {
  public:
    // constructor redefined below
    ~EuropeanEngineHandle();
};

%addmethods EuropeanEngineHandle {
    void crash() {}
    EuropeanEngineHandle() {
        return new EuropeanEngineHandle(new EuropeanEngine);
    }
}


#endif
