
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: TermStructures.i,v 1.29 2002/03/06 16:47:29 lballabio Exp $

#ifndef quantlib_term_structures_i
#define quantlib_term_structures_i

%include Date.i
%include Calendars.i
%include DayCounters.i
%include Types.i
%include Currencies.i
%include Observer.i
%include MarketElements.i
%include Null.i

%{
using QuantLib::TermStructure;
using QuantLib::Handle;
using QuantLib::RelinkableHandle;
typedef Handle<TermStructure> TermStructureHandle;
typedef RelinkableHandle<TermStructure> TermStructureRelinkableHandle;
%}

// export Handle<TermStructure>
%name(TermStructure) class TermStructureHandle : public ObservableHandle {
  private:
    // abstract class - no constructor exported
    TermStructureHandle();
  public:
	~TermStructureHandle();
};

// replicate the TermStructure interface
%addmethods TermStructureHandle {
	Currency currency() {
		return (*self)->currency();
	}
	Date todaysDate() {
		return (*self)->todaysDate();
	}
	Calendar calendar() {
		return (*self)->calendar();
	}
	DayCounter dayCounter() {
		return (*self)->dayCounter();
	}
	int settlementDays() {
		return (*self)->settlementDays();
	}
	Date settlementDate() {
		return (*self)->settlementDate();
	}
	Date maxDate() {
		return (*self)->maxDate();
	}
	Date minDate() {
		return (*self)->minDate();
	}
	Time maxTime() {
		return (*self)->maxTime();
	}
	Time minTime() {
		return (*self)->minTime();
	}
	Rate _zeroYieldVsDate(const Date& d, bool extrapolate = false) {
		return (*self)->zeroYield(d, extrapolate);
	}
	Rate _zeroYieldVsTime(Time t, bool extrapolate = false) {
		return (*self)->zeroYield(t, extrapolate);
	}
	DiscountFactor _discountVsDate(const Date& d, bool extrapolate = false) {
		return (*self)->discount(d, extrapolate);
	}
	DiscountFactor _discountVsTime(Time t, bool extrapolate = false) {
		return (*self)->discount(t, extrapolate);
	}
	Rate _forwardVsDate(const Date& d, bool extrapolate = false) {
		return (*self)->forward(d, extrapolate);
	}
	Rate _forwardVsTime(Time t, bool extrapolate = false) {
		return (*self)->forward(t, extrapolate);
	}
	bool __nonzero__() {
		return !self->isNull();
	}
}

AllowNoneAsInput(TermStructureHandle,TermStructure);


// export RelinkableHandle<TermStructure>
%name(TermStructureHandle) class TermStructureRelinkableHandle 
: public ObservableHandle {
  public:
    TermStructureRelinkableHandle(TermStructureHandle h);
	~TermStructureRelinkableHandle();
	void linkTo(TermStructureHandle);
};

%addmethods TermStructureRelinkableHandle {
    bool __nonzero__() {
        return !self->isNull();
    }
}



// implied term structure

%{
using QuantLib::ImpliedTermStructure;
typedef Handle<ImpliedTermStructure> ImpliedTermStructureHandle;
%}

// fake inheritance between handles
%name(ImpliedTermStructure) class ImpliedTermStructureHandle
: public TermStructureHandle {
  public:
    // constructor redefined below
    ~ImpliedTermStructureHandle();
};

%addmethods ImpliedTermStructureHandle {
    ImpliedTermStructureHandle(TermStructureRelinkableHandle curveHandle,
        Date todaysDate) {
	        return new ImpliedTermStructureHandle(
	            new ImpliedTermStructure(curveHandle,todaysDate));
    }
}

// spreaded term structure

%{
using QuantLib::ZeroSpreadedTermStructure;
typedef Handle<ZeroSpreadedTermStructure> ZeroSpreadedTermStructureHandle;
%}

// fake inheritance between handles
%name(ZeroSpreadedTermStructure) class ZeroSpreadedTermStructureHandle
: public TermStructureHandle {
  public:
    // constructor redefined below
    ~ZeroSpreadedTermStructureHandle();
};

%addmethods ZeroSpreadedTermStructureHandle {
    ZeroSpreadedTermStructureHandle(TermStructureRelinkableHandle curveHandle,
        MarketElementRelinkableHandle spreadHandle) {
	        return new ZeroSpreadedTermStructureHandle(
	            new ZeroSpreadedTermStructure(curveHandle,spreadHandle));
    }
}

%{
using QuantLib::ForwardSpreadedTermStructure;
typedef Handle<ForwardSpreadedTermStructure>
    ForwardSpreadedTermStructureHandle;
%}

// fake inheritance between handles
%name(ForwardSpreadedTermStructure) class ForwardSpreadedTermStructureHandle
: public TermStructureHandle {
  public:
    // constructor redefined below
    ~ForwardSpreadedTermStructureHandle();
};

%addmethods ForwardSpreadedTermStructureHandle {
    ForwardSpreadedTermStructureHandle(TermStructureRelinkableHandle curveHandle,
        MarketElementRelinkableHandle spreadHandle) {
	        return new ForwardSpreadedTermStructureHandle(
	            new ForwardSpreadedTermStructure(curveHandle,spreadHandle));
    }
}

// flat forward curve

%{
using QuantLib::TermStructures::FlatForward;
typedef Handle<FlatForward> FlatForwardHandle;
%}

// fake inheritance between handles
%name(FlatForward) class FlatForwardHandle
: public TermStructureHandle {
  public:
    // constructor redefined below
    ~FlatForwardHandle();
};

%addmethods FlatForwardHandle {
    FlatForwardHandle(Currency currency, DayCounter dayCounter,
        Date todaysDate, Calendar calendar, int settlementDays,
        Rate forward) {
	        return new FlatForwardHandle(
	            new FlatForward(currency,dayCounter,todaysDate,
	                calendar,settlementDays,forward));
    }
}


#endif
